﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "SceneStackedItemMenuPage.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../../ui/ui_MenuItemBox.h"

namespace scene{ namespace menu{

    SceneStackedItemMenuPage::SceneStackedItemMenuPage(const std::shared_ptr<void>& arg) NN_NOEXCEPT
        : SceneMenuPageBase(arg)
    {
        auto param = GetUserArgument<SceneStackedItemMenuPageArgument>();

        auto anchor = param->GetAnchorPosition();

        auto pBox = std::make_shared<ui::MenuItemBox>(
            ui::MenuItemBoxStyle()
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({ScreenWidth, ScreenHeight})
                )
                .SetAlignment(ui::ItemAlignment_TopLeft)
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetMode(ui::BackgroundMode::BackgroundMode_Transparent)
                )
                .SetMargin({anchor.y, 0, 0, anchor.x})
            )
            ->SetInnerItem(param->GetItem())
        ;

        SetMenuItem(pBox);
    }

}}
