﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ScenePowerMenuPage.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include "../../Config.h"
#include "../../ui/ui.h"

#include "../SceneIndex.h"

#include "SceneSandboxMenuPage.h"
#include "../../config/PowerMenuStyle.h"

namespace scene{ namespace menu{

    ScenePowerMenuPage::ScenePowerMenuPage(const std::shared_ptr<void>& arg) NN_NOEXCEPT
        : SceneMenuPageBase(arg)
    {
        const StyleType style;

        SetPanelName("power");

        auto p = std::make_shared<ui::MenuItemBox>(style.MakeRootBoxStyle())
            ->SetInnerItem(
                std::make_shared<ui::MenuItemColumn>(style.MakeMenuTableStyle())
                ->AddCell(style.MakeHeaderCellStyle(),
                    std::make_shared<ui::MenuItemLabel>(style.MakeTitleStyle(), "PowerMenu")
                )
                ->AddCell(std::make_shared<ui::MenuItemLabel>(style.MakeButtonStyle(), "Debug...")
                    ->SetButtonCallbackFunction([](const std::shared_ptr<ui::IMenuPage>& pPage)
                    {
                        NN_DEVOVL_MENU_LOG_INFO("opening debug menu\n");
                        pPage->OpenPage(SceneIndex_DebugMenuPage);
                    })
                )
                ->AddCell(std::make_shared<ui::MenuItemLabel>(style.MakeButtonStyle(), "Sleep")
                    ->SetButtonCallbackFunction([](const std::shared_ptr<ui::IMenuPage>& pPage)
                    {
                        NN_DEVOVL_MENU_LOG_INFO("sleep selected\n");
                        pPage->SleepSystem();
                    })
                )
                ->AddCell(std::make_shared<ui::MenuItemLabel>(style.MakeButtonStyle(), "Shutdown")
                    ->SetButtonCallbackFunction([](const std::shared_ptr<ui::IMenuPage>& pPage)
                    {
                        NN_DEVOVL_MENU_LOG_INFO("shutdown selected\n");
                        pPage->ShutdownSystem();
                    })
                )
                ->AddCell(std::make_shared<ui::MenuItemLabel>(style.MakeButtonStyle(), "Close Menu")
                    ->SetButtonCallbackFunction([](const std::shared_ptr<ui::IMenuPage>& pPage)
                    {
                        NN_DEVOVL_MENU_LOG_INFO("closing power menu\n");
                        pPage->CloseMenu();
                    })
                )
            )
        ;
        SetMenuItem(p);
    };

}}

