﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/nn_Common.h>

namespace scene { namespace debug { namespace logutil {

class TextReaderImpl
{
public:
    TextReaderImpl(const char* const data, const size_t& size) NN_NOEXCEPT;

    bool IsEof(const int64_t& position) const NN_NOEXCEPT { return m_DataSize == position; }
    bool IsOutOfRange(const int64_t& position) const NN_NOEXCEPT { return (position < 0 || m_DataSize < position); }

    nn::Result GetByte(char* buffer, const int64_t& position) NN_NOEXCEPT;

private:

    bool IsCached(const int64_t& position) const NN_NOEXCEPT
    {
        return m_CacheHeadOffset <= position && position < m_CacheHeadOffset + m_UsedCacheSize;
    }

    void LoadToCache(const int64_t& position) NN_NOEXCEPT;

    const char* m_Data;
    const size_t m_DataSize;

    char m_Cache[32];   // キャシュサイズは仮に 32バイトにしておく
    size_t m_UsedCacheSize;
    int64_t m_CacheHeadOffset;
};

}}}
