﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "debug_SceneDebug.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../../Config.h"

namespace scene{ namespace debug{

    SceneDebug g_SceneDebug;
    bool g_IsSavingActivityEnabled = false;

    void SceneDebug::Initialize() NN_NOEXCEPT
    {
        m_CurrentActivity = {};
        m_NextActivity = {};

        m_pRootPanel = std::make_shared<panel::PanelContainer>();
        m_pRootPanel->SetVisibility(panel::PanelVisibility::Invisible);
        m_pRootPanel->SetSize(ScreenWidth, ScreenHeight);
        m_pRootPanel->SetPanelName("debug");
    }

    void SceneDebug::Finalize() NN_NOEXCEPT
    {
        m_CurrentActivity = {};
        m_NextActivity = {};
        m_pRootPanel.reset();

    #define NN_DEVOVL_DEBUGMODULE_RESETPTR(name, data) m_p##name.reset();
        NN_DEVOVL_FOREACH_DEBUGMODULE(NN_DEVOVL_DEBUGMODULE_RESETPTR, _);
    #undef NN_DEVOVL_DEBUGMODULE_RESETPTR
    }

    void SceneDebug::Update() NN_NOEXCEPT
    {
        UpdateActivityImpl();

    #define NN_DEVOVL_DEBUGMODULE_UPDATE(name, data) \
        if(m_p##name){ m_p##name->Update(); }

        NN_DEVOVL_FOREACH_DEBUGMODULE(NN_DEVOVL_DEBUGMODULE_UPDATE, _);

    #undef NN_DEVOVL_DEBUGMODULE_UPDATE
    }

    std::shared_ptr<panel::IPanel> SceneDebug::GetPanel() NN_NOEXCEPT
    {
        return m_pRootPanel;
    }

    bool SceneDebug::IsActive() const NN_NOEXCEPT
    {
        // 何か 1 つでも有効化されていれば true
    #define NN_DEVOVL_DEBUGMODULE_ISACTIVE(name, data) if(m_p##name) { return true; }

        NN_DEVOVL_FOREACH_DEBUGMODULE(NN_DEVOVL_DEBUGMODULE_ISACTIVE, _);

    #undef NN_DEVOVL_DEBUGMODULE_ISACTIVE

        return false;
    }

    Activity SceneDebug::GetCurrentActivity() const NN_NOEXCEPT
    {
        return m_CurrentActivity;
    }

    void SceneDebug::SubmitActivity(const Activity& value) NN_NOEXCEPT
    {
        m_NextActivity = value;
    }

    void SceneDebug::UpdateActivityImpl() NN_NOEXCEPT
    {
        auto& next = m_NextActivity;

    #define NN_DEVOVL_DEBUGMODULE_UPDATEACTIVITY(module, data)    \
        if(next.activity##module.IsSupported && next.activity##module.common.isEnabled) \
        {                                                   \
            if(!m_p##module)                                  \
            {                                               \
                NN_DEVOVL_DEBUG_LOG_INFO("activating %s\n", next.activity##module.common.name.value);   \
                m_p##module = std::make_shared<module>();       \
            }                                               \
            m_p##module->SetActivity(next.activity##module);    \
        }                                                   \
        else                                                \
        {                                                   \
            if(m_p##module)                                   \
            {                                               \
                NN_DEVOVL_DEBUG_LOG_INFO("deactivating %s\n", next.activity##module.common.name.value);   \
            }                                               \
            m_p##module.reset();                              \
        }

        NN_DEVOVL_FOREACH_DEBUGMODULE(NN_DEVOVL_DEBUGMODULE_UPDATEACTIVITY, _);

    #undef NN_DEVOVL_DEBUGMODULE_UPDATEACTIVITY


        // Panel の更新
        {
            std::vector<std::shared_ptr<panel::IPanel>> list;

        #define NN_DEVOVL_DEBUGMODULE_GATHERPANEL(name, data)   \
            if(m_p##name){                                      \
                if(auto pPanel = m_p##name->GetPanel())         \
                {                                               \
                    list.push_back(pPanel);                     \
                }                                               \
            }

            NN_DEVOVL_FOREACH_DEBUGMODULE(NN_DEVOVL_DEBUGMODULE_GATHERPANEL, _);

        #undef NN_DEVOVL_DEBUGMODULE_GATHERPANEL

            m_pRootPanel->SetChildren(list);
            m_pRootPanel->SetVisibility(m_pRootPanel->GetChildrenCount() > 0 ? panel::PanelVisibility::Transparent : panel::PanelVisibility::Invisible);
        }

        m_CurrentActivity = m_NextActivity;
    }// NOLINT(impl/function_size)

}}
