﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../../panel/panel_IPanel.h"
#include "../../panel/panel_PanelContainer.h"
#include "../../panel/panel_PanelText.h"
#include "debug_ActivityClock.h"

namespace scene{ namespace debug{

    class Clock
    {
    public:
        // このモジュールが有効化された際にコンストラクタが呼ばれる。
        // 無効化される際にデストラクタが呼ばれる。
        Clock() NN_NOEXCEPT;

        // 描画用オブジェクトを取得する。
        std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT;

        // このモジュールが有効な間、 1 フレームに 1 回呼ばれる。
        void Update() NN_NOEXCEPT;

        // 設定を反映する。
        // コンストラクタが呼ばれた直後や設定が変更された直後に呼ばれる。
        void SetActivity(const ActivityClock& value) NN_NOEXCEPT;

    private:
        ActivityClock m_Activity = {};
        std::shared_ptr<panel::PanelContainer> m_pContainer;
        std::shared_ptr<panel::PanelText> m_pPanelText;
    };

}}
