﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/gfx.h>
#include "panel_IPanel.h"
#include "panel_PanelBase.h"

namespace panel{

    class PanelHistorical
        : public PanelBase<IPanel>
    {
    public:
        PanelHistorical() NN_NOEXCEPT;

        void SetOffset(int offsetX, int offsetY) NN_NOEXCEPT;

        int GetOffsetX() const NN_NOEXCEPT;
        int GetOffsetY() const NN_NOEXCEPT;

        bool IsHistoryValid() const NN_NOEXCEPT;

        PANEL_CAST_FUNCTION(Historical);
    private:
        int m_OffsetX;
        int m_OffsetY;
    };

}
