﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "panel_PanelHistorical.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>


namespace panel{
    PanelHistorical::PanelHistorical()
        : PanelBase(PanelType_Historical)
        , m_OffsetX(0)
        , m_OffsetY(0)
    {
        this->SetForceRedrawImpl(true);
    }

    void PanelHistorical::SetOffset(int offsetX, int offsetY) NN_NOEXCEPT
    {
        m_OffsetX = offsetX;
        m_OffsetY = offsetY;
    }

    int PanelHistorical::GetOffsetX() const NN_NOEXCEPT
    {
        return m_OffsetX;
    }

    int PanelHistorical::GetOffsetY() const NN_NOEXCEPT
    {
        return m_OffsetY;
    }

    bool PanelHistorical::IsHistoryValid() const NN_NOEXCEPT
    {
        // とりあえず今のところキャッシュがあるかで判定できる
        return GetRenderingRecycleCache().IsValid();
    }
}
