﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "../ThreadMessageChannel.h"

#include "../ResourceUsage.h"

namespace detail{

    class SleepScheduler
    {
    public:
        SleepScheduler() NN_NOEXCEPT
            : m_FrameToSleep(0)
            , m_pReporter()
        {
        }

        void Schedule(int frameToSleep, std::shared_ptr<ThreadMessageResultReporter>&& pReporter) NN_NOEXCEPT
        {
            m_FrameToSleep = frameToSleep;
            m_pReporter = std::move(pReporter);
        }

        int GetFrameToSleep() const NN_NOEXCEPT
        {
            return m_FrameToSleep;
        }

        bool IsScheduled() const NN_NOEXCEPT
        {
            return m_FrameToSleep > 0;
        }

        // スリープに入る場合 true を返す。
        bool UpdateToSleep() NN_NOEXCEPT
        {
            if(m_FrameToSleep <= 0)
            {
                return false;
            }

            m_FrameToSleep--;

            if(m_FrameToSleep == 0)
            {
                m_pReporter->NotifyCompletion(ThreadMessageResult_Success);
                m_pReporter.reset();
                return true;
            }
            else
            {
                return false;
            }
        }

    public:
        // 非正ならスリープしない。0 になったらスリープする
        int m_FrameToSleep;
        // スリープ開始時に通知する reporter
        std::shared_ptr<ThreadMessageResultReporter> m_pReporter;
    };

}
