﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "../ui/ui.h"

namespace config{

    class DebugMenuStyle
    {
    public:
        static const int PageWidth = 1200;
        static const int PageHeight = 680;

        static const int PageBorderLineWidth = 1;
        static const int PageHeaderWidth  = PageWidth;
        static const int PageHeaderHeight = 80;
        static const int PageFooterWidth  = PageWidth;
        static const int PageFooterHeight = 80;

        static const int PageBodyWidth  = PageWidth;
        static const int PageBodyHeight = PageHeight - PageHeaderHeight - PageFooterHeight - 2 * PageBorderLineWidth;

        static const int PageBodyConfigWidth    = 400;
        static const int PageBodyConfigHeight   = PageBodyHeight;
        static const int PageBodyConfigScrollbarWidth = 8;

        static const int PageBodyLayoutEditorWidth  = PageWidth - PageBodyConfigWidth;
        static const int PageBodyLayoutEditorHeight = PageBodyHeight;

        const nn::util::Color4f m_BackgroundColor = {0, 0, 0, .75f};
        const nn::util::Color4f m_BackgroundColorFocused = {1, .2f, .2f, .75f};
        const nn::util::Color4f m_TextColor         = {1, 1, 1, 1};
        const nn::util::Color4f m_TextColorSelected = {1, 0, 0, 1};
        const nn::util::Color4f m_ScrollbarBarColor  = {.2f, .2f, .2f, .75f};
        const nn::util::Color4f m_ScrollbarKnobColor = {1, 0, 0, .75f};
        const nn::util::Color4f m_BorderLineColor   = {1, 1, 1, 1};
        const nn::util::Color4f m_ButtonEdgeColor   = {1, 1, 1, 1};

        // ボタンなどの UI の色。
        const nn::util::Color4f m_UiForeColor         = {.1f, .1f, .1f, 1};
        const nn::util::Color4f m_UiForeColorFocused  = {1, .2f, .2f, 1};
        const nn::util::Color4f m_UiForeColorDisabled = {0, 0, 0, .75f};
        const nn::util::Color4f m_UiBackColor         = {0, 0, 0, .75f};
        const nn::util::Color4f m_UiBackColorFocused  = {1, .2f, .2f, 1};
        const nn::util::Color4f m_UiBackColorDisabled = {0, 0, 0, .75f};
        const nn::util::Color4f m_UiFontColor         = {1, 1, 1, 1};
        const nn::util::Color4f m_UiFontColorSelected = {1, 0, 0, 1};
        const nn::util::Color4f m_UiFontColorDisabled = {.2f, .2f, .2f, .75f};

        //-----------------------------------
        // Table
        //-----------------------------------

        ui::MenuItemTableStyle MakePageTableStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemTableStyle()
                .SetBorderStyle(ui::BorderStyle()
                    .SetColor(m_BorderLineColor)
                    .SetInnerWidth(PageBorderLineWidth, 0)
                )
            ;
        }

        //-----------------------------------
        // Header
        //-----------------------------------

        static const int TitleTextSize = 32;

        ui::MenuItemLabelStyle MakeTitleStyle() const NN_NOEXCEPT
        {
            auto v = ui::MenuItemLabelStyle()
                .SetBackgroundColor(m_BackgroundColor)
                .SetTextStyle(ui::TextStyle()
                    .SetFontColor(m_TextColor)
                    .SetFontSize(TitleTextSize)
                )
            ;
            return v;
        }

        //-----------------------------------
        // Footer
        //-----------------------------------

        static const int OkButtonWidth = 300;
        static const int OkButtonHeight = 60;
        static const int OkButtonBorderWidth = 1;
        static const int OkButtonFontSize = 24;

        ui::MenuItemTableCellStyle MakeFooterTableCellStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemTableCellStyle()
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetColor(m_BackgroundColor)
                )
                .SetAlignment(ui::ItemAlignment_MiddleCenter)
            ;
        }

        ui::MenuItemBoxStyle MakeOkButtonBorderStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemBoxStyle()
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetColor(m_ButtonEdgeColor)
                )
                .SetMargin({OkButtonBorderWidth, OkButtonBorderWidth, OkButtonBorderWidth, OkButtonBorderWidth})
                .SetSizeStyle(ui::SizeStyle()
                    .SetAutoSize({})
                )
            ;
        }

        ui::MenuItemLabelStyle MakeOkButtonStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemLabelStyle()
                .SetBackgroundColor(ui::ItemStateFilter_Any,      m_UiForeColor)
                .SetBackgroundColor(ui::ItemStateFilter_InFocus,  m_UiForeColorFocused)
                .SetBackgroundColor(ui::ItemStateFilter_Disabled, m_UiForeColorDisabled)
                .SetTextStyle(ui::ItemStateFilter_Any, ui::TextStyle()
                    .SetFontColor(m_UiFontColor)
                    .SetFontSize(OkButtonFontSize)
                )
                .SetTextStyle(ui::ItemStateFilter_Disabled, ui::TextStyle()
                    .SetFontColor(m_UiFontColorDisabled)
                    .SetFontSize(OkButtonFontSize)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({OkButtonWidth - 2 * OkButtonBorderWidth, OkButtonHeight - 2 * OkButtonBorderWidth})
                )
                .SetAlignment(ui::ItemAlignment_MiddleCenter)
            ;
        }

        ui::MenuItemCheckBoxStyle MakeSaveActivityCheckBoxStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemCheckBoxStyle()
                .SetAlignment(ui::ItemAlignment_MiddleLeft)
                .SetBackgroundColor(ui::ItemStateFilter_Any    , m_UiBackColor)
                .SetBackgroundColor(ui::ItemStateFilter_InFocus, m_UiBackColorFocused)
                .SetSizeStyle(ui::SizeStyle()
                    .SetAutoSize({})
                )
                .SetTextStyle(ui::TextStyle()
                    .SetFontColor(m_TextColor)
                    .SetFontSize(OptionFontSize)
                )
                .SetCheckMarkStyle(ui::CheckMarkStyle()
                    .SetSize(OptionModuleCheckBoxIconSize, OptionModuleCheckBoxIconSize)
                    .SetCheckMarkColor(m_OptionModuleCheckBoxIconColorNotChecked)
                    .SetCheckMarkSize(OptionModuleCheckBoxIconSize)
                    .SetBorderWidth(1)
                    .SetBorderColor({1, 1, 1})
                    .SetBackgroundColor(m_UiBackColor)
                )
                .SetCheckMarkStyle(ui::ItemStateFilter_Selected, ui::CheckMarkStyle()
                    .SetSize(OptionModuleCheckBoxIconSize, OptionModuleCheckBoxIconSize)
                    .SetCheckMarkColor(m_OptionModuleCheckBoxIconColorChecked)
                    .SetCheckMarkSize(OptionModuleCheckBoxIconSize)
                    .SetBorderWidth(1)
                    .SetBorderColor({1, 1, 1})
                    .SetBackgroundColor(m_UiBackColor)
                )
                .SetMargin({0, 8, 0, 8})
            ;
        }


        //-----------------------------------
        // Body
        //-----------------------------------

        // Option
        static const int OptionMarginDefault = 4;
        static const int OptionFontSize = 24;
        static const int OptionListArrowButtonScrollDistance = 64;
        static const int OptionListAnalogStickScrollDistanceMax = 32;

        ui::MenuItemScrollBoxStyle MakeOptionListScrollBoxStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemScrollBoxStyle()
                .SetAlignment(ui::ItemAlignment_TopLeft)
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetColor(m_BackgroundColor)
                )
                .SetVerticalScrollbarStyle(ui::ScrollbarStyle()
                    .SetBarColor(m_ScrollbarBarColor)
                    .SetKnobColor(m_ScrollbarKnobColor)
                    .SetMode(ui::ScrollbarMode_Always)
                    .SetWidth(PageBodyConfigScrollbarWidth)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({PageBodyConfigWidth, PageBodyConfigHeight})
                )
                .SetArrowButtonScrollDistance(OptionListArrowButtonScrollDistance)
                .SetAnalogStickScrollDistanceMax(OptionListAnalogStickScrollDistanceMax)
            ;
        }

        // ModuleHeader
        // +------------------------+
        // |[/]ModuleName           |
        // +------------------------+
        // |               [Layout] |
        // +------------------------+

        static const int OptionModuleNameWidth  = PageBodyConfigWidth - PageBodyConfigScrollbarWidth;
        static const int OptionModuleNameHeight = 40;
        const nn::util::Color4f m_OptionModuleNameBackgroundColor        = {.1f, 0, 0, .75f};
        const nn::util::Color4f m_OptionModuleNameBackgroundColorFocused = {.5f, .1f, .1f, 1};

        static const int OptionModuleCheckBoxIconSize = 32;
        const nn::util::Color4f m_OptionModuleCheckBoxIconColorNotChecked = {.1f, .1f, .1f, .75f};
        const nn::util::Color4f m_OptionModuleCheckBoxIconColorChecked    = {0, 1, 0, 1};

        ui::MenuItemTableCellStyle MakeOptionModuleNameCellStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemTableCellStyle()
                .SetAlignment(ui::ItemAlignment_MiddleLeft)
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetMode(ui::BackgroundMode_InnerItem)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetAutoSize({})
                )
            ;
        }

        ui::MenuItemCheckBoxStyle MakeOptionModuleNameCheckBoxStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemCheckBoxStyle()
                .SetAlignment(ui::ItemAlignment_MiddleLeft)
                .SetBackgroundColor(ui::ItemStateFilter_Any    , m_UiForeColor)
                .SetBackgroundColor(ui::ItemStateFilter_InFocus, m_UiForeColorFocused)
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({OptionModuleNameWidth, OptionModuleNameHeight})
                )
                .SetTextStyle(ui::TextStyle()
                    .SetFontColor(m_TextColor)
                    .SetFontSize(OptionFontSize)
                )
                .SetCheckMarkStyle(ui::CheckMarkStyle()
                    .SetSize(OptionModuleCheckBoxIconSize, OptionModuleCheckBoxIconSize)
                    .SetCheckMarkColor(m_OptionModuleCheckBoxIconColorNotChecked)
                    .SetCheckMarkSize(OptionModuleCheckBoxIconSize)
                    .SetBorderWidth(1)
                    .SetBorderColor({1, 1, 1})
                    .SetBackgroundColor(m_UiBackColor)
                )
                .SetCheckMarkStyle(ui::ItemStateFilter_Selected, ui::CheckMarkStyle()
                    .SetSize(OptionModuleCheckBoxIconSize, OptionModuleCheckBoxIconSize)
                    .SetCheckMarkColor(m_OptionModuleCheckBoxIconColorChecked)
                    .SetCheckMarkSize(OptionModuleCheckBoxIconSize)
                    .SetBorderWidth(1)
                    .SetBorderColor({1, 1, 1})
                    .SetBackgroundColor(m_UiBackColor)
                )
                .SetMargin({0, 0, 0, OptionMarginDefault})
            ;
        }

        ui::MenuItemLabelStyle MakeModuleNameLabelStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemLabelStyle()
                .SetAlignment(ui::ItemAlignment_MiddleLeft)
                .SetBackgroundColor(m_OptionModuleNameBackgroundColor)
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({OptionModuleNameWidth, OptionModuleNameHeight})
                )
                .SetTextStyle(ui::TextStyle()
                    .SetFontColor(m_TextColor)
                    .SetFontSize(OptionFontSize)
                )
                .SetMargin({0, 0, 0, OptionMarginDefault})
            ;
        }

        ui::MenuItemTableCellStyle MakeOptionLayoutButtonCellStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemTableCellStyle()
                .SetAlignment(ui::ItemAlignment_MiddleRight)
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetColor(m_BackgroundColor)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetAutoSize({})
                )
            ;
        }

        // +-----------+------------+
        // +        Key|Value       |
        // +-----------+------------+

        static const int OptionSpacerCellWidth  = PageBodyConfigWidth - PageBodyConfigScrollbarWidth;
        static const int OptionSpacerCellHeight = 10;
        static const int OptionKeyCellWidth  = PageBodyConfigWidth / 2;
        static const int OptionKeyCellHeight = 60;
        static const int OptionValueCellWidth  = PageBodyConfigWidth - OptionKeyCellWidth - PageBodyConfigScrollbarWidth;
        static const int OptionValueCellHeight = OptionKeyCellHeight;

        ui::MenuItemTableCellStyle MakeOptionSpacerCellStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemTableCellStyle()
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetColor(m_BackgroundColor)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({OptionSpacerCellWidth, OptionSpacerCellHeight})
                )
            ;
        }

        ui::MenuItemTableCellStyle MakeOptionKeyCellStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemTableCellStyle()
                .SetAlignment(ui::ItemAlignment_MiddleRight)
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetMode(ui::BackgroundMode_InnerItem)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({OptionKeyCellWidth, OptionKeyCellHeight})
                )
            ;
        }

        ui::MenuItemLabelStyle MakeOptionKeyLabelStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemLabelStyle()
                .SetAlignment(ui::ItemAlignment_MiddleRight)
                .SetBackgroundColor(m_BackgroundColor)
                .SetMargin({0, OptionMarginDefault, 0, 0})
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({OptionKeyCellWidth, OptionKeyCellHeight})
                )
                .SetTextStyle(ui::TextStyle()
                    .SetFontColor(m_TextColor)
                    .SetFontSize(OptionFontSize)
                )
            ;
        }

        ui::MenuItemTableCellStyle MakeOptionValueCellStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemTableCellStyle()
                .SetAlignment(ui::ItemAlignment_MiddleLeft)
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetColor(m_BackgroundColor)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({OptionValueCellWidth, OptionValueCellHeight})
                )
            ;
        }

        // Value の中身

        static const int OptionValueBorderWidth = 1;

        ui::MenuItemBoxStyle MakeOptionValueBorderStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemBoxStyle()
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetColor(m_ButtonEdgeColor)
                )
                .SetMargin({OptionValueBorderWidth, OptionValueBorderWidth, OptionValueBorderWidth, OptionValueBorderWidth})
                .SetSizeStyle(ui::SizeStyle()
                    .SetAutoSize({})
                )
            ;
        }

        ui::MenuItemLabelStyle MakeOptionValueButtonStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemLabelStyle()
                .SetBackgroundColor(ui::ItemStateFilter_Any,      m_UiForeColor)
                .SetBackgroundColor(ui::ItemStateFilter_InFocus,  m_UiForeColorFocused)
                .SetBackgroundColor(ui::ItemStateFilter_Disabled, m_UiForeColorDisabled)
                .SetTextStyle(ui::ItemStateFilter_Any, ui::TextStyle()
                    .SetFontColor(m_UiFontColor)
                    .SetFontSize(OptionFontSize)
                )
                .SetTextStyle(ui::ItemStateFilter_Disabled, ui::TextStyle()
                    .SetFontColor(m_UiFontColorDisabled)
                    .SetFontSize(OptionFontSize)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({
                        OptionValueCellWidth  - 2 * OptionValueBorderWidth,
                        OptionValueCellHeight - 2 * OptionValueBorderWidth
                    })
                )
                .SetAlignment(ui::ItemAlignment_MiddleCenter)
            ;
        }

        static const int OptionValueDropDownPopupRegionX = 0;
        static const int OptionValueDropDownPopupRegionY = 0;
        static const int OptionValueDropDownPopupRegionWidth  = ScreenWidth;
        static const int OptionValueDropDownPopupRegionHeight = ScreenHeight;
        static const int OptionValueDropDownPopupArrowButtonScrollDistance = OptionListArrowButtonScrollDistance;
        static const int OptionValueDropDownPopupAnalogStickScrollDistanceMax = OptionListAnalogStickScrollDistanceMax;

        ui::MenuItemDropDownListStyle MakeOptionValueDropDownListStyle() const NN_NOEXCEPT
        {
            auto v = ui::MenuItemDropDownListStyle()
                .SetBackgroundColor(ui::ItemStateFilter_Any,      m_UiBackColor)
                .SetBackgroundColor(ui::ItemStateFilter_InFocus,  m_UiBackColorFocused)
                .SetBackgroundColor(ui::ItemStateFilter_Disabled, m_UiBackColorDisabled)
                .SetTextStyle(ui::ItemStateFilter_Any,      ui::TextStyle().SetFontSize(OptionFontSize).SetFontColor(m_UiFontColor))
                .SetTextStyle(ui::ItemStateFilter_Selected, ui::TextStyle().SetFontSize(OptionFontSize).SetFontColor(m_UiFontColorSelected))
                .SetTextStyle(ui::ItemStateFilter_Disabled, ui::TextStyle().SetFontSize(OptionFontSize).SetFontColor(m_UiFontColorDisabled))
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({
                        OptionValueCellWidth  - 2 * OptionValueBorderWidth,
                        OptionValueCellHeight - 2 * OptionValueBorderWidth
                    })
                )
                .SetAlignment(ui::ItemAlignment_MiddleLeft)
                .SetDropDownPopupStyle(ui::MenuItemDropDownPopupStyle()
                    .SetRegion({
                        {OptionValueDropDownPopupRegionX, OptionValueDropDownPopupRegionY},
                        {OptionValueDropDownPopupRegionWidth, OptionValueDropDownPopupRegionHeight}
                    })
                    .SetHorizontalScrollbarStyle(ui::ScrollbarStyle()
                        .SetMode(ui::ScrollbarMode_None)
                    )
                    .SetVerticalScrollbarStyle(ui::ScrollbarStyle()
                        .SetMode(ui::ScrollbarMode_Always)
                        .SetBarColor(m_ScrollbarBarColor)
                        .SetKnobColor(m_ScrollbarKnobColor)
                        .SetWidth(PageBodyConfigScrollbarWidth)
                    )
                    .SetArrowButtonScrollDistance(OptionValueDropDownPopupArrowButtonScrollDistance)
                    .SetAnalogStickScrollDistanceMax(OptionValueDropDownPopupAnalogStickScrollDistanceMax)
                )
            ;
            return v;
        }

        //-----------------------------------
        // Body(LayoutEdit)
        //-----------------------------------

        static const int LayoutEditMoveButtonDistance = 16;
        static const int LayoutEditMoveStickDistance = 16;
        static const int LayoutEditArrowButtonWidth  = 80;
        static const int LayoutEditArrowButtonHeight = 80;
        static const int LayoutEditArrowIconSize = 40;
        static const int LayoutEditStickIconSize = 40;

        ui::MenuItemTableCellStyle MakeLayoutEditArrowButtonCellStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemTableCellStyle()
                .SetAlignment(ui::ItemAlignment_MiddleCenter)
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetColor(m_BackgroundColor)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({LayoutEditArrowButtonWidth, LayoutEditArrowButtonHeight})
                )
            ;
        }

        ui::MenuItemIconStyle MakeLayoutEditArrowButtonStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemIconStyle()
                .SetBackgroundColor(ui::ItemStateFilter_Any,      m_UiForeColor)
                .SetBackgroundColor(ui::ItemStateFilter_InFocus,  m_UiForeColorFocused)
                .SetBackgroundColor(ui::ItemStateFilter_Disabled, m_UiForeColorDisabled)
                .SetIconStyle(ui::ItemStateFilter_Any, ui::IconStyle()
                    .SetIconColor(m_UiFontColor)
                    .SetIconSize(LayoutEditArrowIconSize)
                )
                .SetIconStyle(ui::ItemStateFilter_Disabled, ui::IconStyle()
                    .SetIconColor(m_UiFontColorDisabled)
                    .SetIconSize(LayoutEditArrowIconSize)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({
                        LayoutEditArrowButtonWidth  - 2 * OptionValueBorderWidth,
                        LayoutEditArrowButtonHeight - 2 * OptionValueBorderWidth
                    })
                )
                .SetAlignment(ui::ItemAlignment_MiddleCenter)
            ;
        }

        ui::MenuItemIconStyle MakeLayoutEditStickIconStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemIconStyle()
                .SetBackgroundColor(ui::ItemStateFilter_Any,      m_UiBackColor)
                .SetBackgroundColor(ui::ItemStateFilter_InFocus,  m_UiBackColorFocused)
                .SetBackgroundColor(ui::ItemStateFilter_Disabled, m_UiBackColorDisabled)
                .SetIconStyle(ui::ItemStateFilter_Any, ui::IconStyle()
                    .SetIconColor(m_UiFontColor)
                    .SetIconSize(LayoutEditStickIconSize)
                )
                .SetIconStyle(ui::ItemStateFilter_Disabled, ui::IconStyle()
                    .SetIconColor(m_UiFontColorDisabled)
                    .SetIconSize(LayoutEditStickIconSize)
                )
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({
                        LayoutEditArrowButtonWidth,
                        LayoutEditArrowButtonHeight
                    })
                )
                .SetAlignment(ui::ItemAlignment_MiddleCenter)
            ;
        }

    };

    class DebugModuleLayoutEditorStyle
    {
    public:
        static const int CanvasWidth  = ScreenWidth;
        static const int CanvasHeight = ScreenHeight;
        static const int ViewWidth    = 768;
        static const int ViewHeight   = ViewWidth * CanvasHeight / CanvasWidth;

        nn::util::Color4f m_CanvasColor = {.2f, .2f, .2f, .75f};
        nn::util::Color4f m_ActiveModuleColor = {.5f, 0, 0, .75f};
        nn::util::Color4f m_InactiveModuleColor = {.5f, .5f, .5f, .75f};

        static nn::util::Color4f MakeBackgroundColor() NN_NOEXCEPT { return {0, 0, 0, .75f}; }

    };

}
