﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <functional>

#include <nn/account/account_Types.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/web/offline_ApiPrivate.h>

namespace devmenu { namespace launcher {

/**
 * @brief       DevMenu が LA を起動したかどうかを返します。
 */
bool IsLibraryAppletLaunchedByDevMenu() NN_NOEXCEPT;

/**
 * @brief       ネットワークサービスアカウントの可用性を確認し、必要に応じてネットワークサービスアカウントを有効化します。
 */
const nn::Result EnsureNetworkServiceAccountAvailable( const nn::account::Uid& userId ) NN_NOEXCEPT;

/**
 * @brief       アプリケーションの「リーガル情報」を開きます。
 */
const nn::Result ShowApplicationLegalInformationPage(
    nn::web::OfflineHtmlPageReturnValue* pOutOfflineHtmlPageReturnValue,
    const nn::web::ShowApplicationLegalInformationPageArg& showApplicationLegalInformationPageArg ) NN_NOEXCEPT;

/**
 * @brief       エラービューアを使用して記録されたエラーを表示します。
 */
void ShowErrorRecord( const void* pRecordedErrorParam, size_t recordedErrorParamSize ) NN_NOEXCEPT;

/**
 * @brief       利用要求提出の結果に対するハンドリングを行います。
 */
const nn::Result HandleNetworkRequestResult( nn::nifm::NetworkConnection* pNetworkConnection ) NN_NOEXCEPT;

/**
 * @brief       LaunchSoftwareKeyboardAndGetString() に渡すコンフィグです
 */
struct KeyboardConfig
{
    enum Preset
    {
        Preset_Default = 0,
        Preset_UserName,
    };

    enum KeyboardMode
    {
        KeyboardMode_Full = 0,
        KeyboardMode_Ascii,
    };

    Preset          preset;
    KeyboardMode    keyboardMode;
    bool            isPredictionEnabled;
    bool            isUseUtf8;
    bool            isUseNewLine;
    int32_t         textMaxLength;
    int32_t         textMinLength;
    const char*     headerTextUtf8;
    const char*     guideTextUtf8;
};

/**
 * @brief   キーボードアプレットから文字列入力を受け取ります。
 *
 * @deatil  キーボード入力がキャンセルされた場合、nn::swkbd::ResultCanceled が返ります。
 */
const nn::Result LaunchSoftwareKeyboardAndGetString(
    char* pOutString, size_t outSize, const char* pInitialText, const KeyboardConfig& keyboardConfig ) NN_NOEXCEPT;

}} // ~namespace devmenu::launcher
