﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/settings/system/settings_ErrorReport.h>
#include "../DevMenu_Common.h"
#include "../Common/DevMenu_CommonCheckBox.h"
#include "../Common/DevMenu_CommonDropDown.h"
#include "../Common/DevMenu_CommonScene.h"

namespace devmenu {
class Page;
}

namespace devmenu { namespace error {

class ErrorSettingsScene : public devmenu::Scene
{
public:
    ErrorSettingsScene(devmenu::Page* pParent, glv::Rect rect) NN_NOEXCEPT;

    void Activate() NN_NOEXCEPT;
    void Deactivate() NN_NOEXCEPT;

    glv::View* GetFocusableChild() const NN_NOEXCEPT;
    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;
private:
    void UpdateUploadCheckBox() NN_NOEXCEPT;
    void RefreshStatusLabel() NN_NOEXCEPT;
#if defined( NN_DEVMENUSYSTEM )
    void UpdateAutoUploadWithoutOptedInAccountCheckBox() NN_NOEXCEPT;
#endif

    bool m_IsUploadEnabledInCurrentBoot;
    glv::Table m_Layout;
    // 作成されるクラッシュレポートがクラッシュレポート取得ツールで参照可能な状態になるか（アップロードが有効 && レポートの第三者共有許可済み）を表す。
    CheckBoxButton m_UploadCheckBox;
#if defined( NN_DEVMENUSYSTEM )
    CheckBoxButton m_AutoUploadWithoutOptedInAccountCheckBox;
#endif
    glv::Label m_StatusLabel;
    nn::os::TimerEvent m_StatusRefreshTimer{ nn::os::EventClearMode_AutoClear };
};

}} // ~namespace devmenu::error, ~namespace devmenu
