﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenu_CommonIconButton.h"

namespace devmenu {

IconButton::IconButton( const glv::Rect& rect, bool printsBorder ) NN_NOEXCEPT
    : glv::Button( rect )
    , m_pIconLabel(nullptr)
    , m_Callback(nullptr)
{
    this->SetDefaultButtonStyles( printsBorder );
}

IconButton::IconButton( const glv::Rect& rect, bool printsBorder, IconLabel* pIconLabel ) NN_NOEXCEPT
    : glv::Button( rect )
    , m_pIconLabel(pIconLabel)
    , m_Callback(nullptr)
{
    this->SetDefaultButtonStyles( printsBorder );
    this->add( pIconLabel );
}

IconButton::IconButton( const glv::Rect& rect, bool printsBorder, IconLabel* pIconLabel, std::function< void() > callback, float fontSize ) NN_NOEXCEPT
    : glv::Button( rect )
    , m_pIconLabel(pIconLabel)
    , m_Callback(callback)
{
    this->SetDefaultButtonStyles( printsBorder );
    pIconLabel->size( fontSize );
    this->add( pIconLabel );
    attach( []( const glv::Notification& n )->void { n.receiver< IconButton >()->m_Callback(); }, glv::Update::Clicked, this );
}


void IconButton::onDraw( glv::GLV& glvRoot ) NN_NOEXCEPT
{
    // On Draw function to override the button pressed effect.
}

void IconButton::SetDefaultButtonStyles( bool printsBorder ) NN_NOEXCEPT
{
    // Disable Background
    disable( glv::Property::DrawBack );
    // Enable Focus Highlight and properties used to determine if an element is focusable
    enable( glv::Property::FocusHighlight | glv::Property::HitTest | glv::Property::Visible );
    // Check if this button should have a border
    if ( printsBorder )
    {
        // Enable Border
        enable( glv::Property::DrawBorder );
    }
    else
    {
        // Disable Border
        disable( glv::Property::DrawBorder );
    }
}

} // ~namespace devmenu
