﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../DevMenu_Common.h"

namespace devmenu {

template < typename DebugButtonFlagT, typename BasicButtonFlagT >
struct FocusButtonFlag
{
    static const int DebugButtonIndex = DebugButtonFlagT::Index;
    static const int BasicButtonIndex = BasicButtonFlagT::Index;
};

typedef FocusButtonFlag< glv::DebugPadEventType::ButtonUp, glv::BasicPadEventType::Button::Up > FocusButtonUp;
typedef FocusButtonFlag< glv::DebugPadEventType::ButtonDown, glv::BasicPadEventType::Button::Down > FocusButtonDown;
typedef FocusButtonFlag< glv::DebugPadEventType::ButtonRight, glv::BasicPadEventType::Button::Right > FocusButtonRight;
typedef FocusButtonFlag< glv::DebugPadEventType::ButtonLeft, glv::BasicPadEventType::Button::Left > FocusButtonLeft;

class FocusManager : public glv::EventHandler
{
public:
    struct FocusSwitch
    {
        glv::View* pPreviousView;
        glv::View* pNextView;
        int debugButtonIndex;
        int basicButtonIndex;
    };

public:
    template < typename ButtonFlagT >
    void AddFocusSwitch(glv::View* pFrom, glv::View* pTo) NN_NOEXCEPT
    {
        pFrom->addHandler(glv::Event::BasicPadDown, *this);
        pFrom->addHandler(glv::Event::BasicPadRepeat, *this);
        pFrom->addHandler(glv::Event::DebugPadDown, *this);
        pFrom->addHandler(glv::Event::DebugPadRepeat, *this);
        FocusSwitch focusSwitch = { pFrom, pTo, ButtonFlagT::DebugButtonIndex, ButtonFlagT::BasicButtonIndex };
        m_FocusSwitchList.push_back(focusSwitch);
    }

    void Clear() NN_NOEXCEPT;

    virtual bool onEvent(glv::View& view, glv::GLV& glvRoot) NN_NOEXCEPT;

protected:
    const std::vector< FocusSwitch >& GetFocusSwitchList() const NN_NOEXCEPT
    {
        return m_FocusSwitchList;
    }

private:
    std::vector< FocusSwitch > m_FocusSwitchList;
};

} // ~namespace devmenu
