﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DevMenu_CloudBackupCommons.h"


namespace devmenu { namespace cloudbackup {

/**
* TODO:devmenu::error::ErrorProperty 相当にすべきか？
* error list に表示する情報
*/
struct ErrorItem
{
    const int id;
    const std::string name;
};

/**
* エラーリストのビュー
*/
class ErrorView : public glv::Button
{
public:
    ErrorView(const glv::Rect& rect, const std::function<void(const int id)>& clickCallback,
        const ErrorItem& errorInfo) NN_NOEXCEPT
        : glv::Button(rect, true)
        , m_Id(errorInfo.id)
        , m_Label(errorInfo.name, DefaultLabelSpec)
        , m_Callback(clickCallback)
    {
        *this << m_Label;

        attach([](const glv::Notification& n)->void {
            n.receiver< ErrorView >()->OnClick(); }, glv::Update::Clicked, this);
    }

private:

    void OnClick() NN_NOEXCEPT
    {
        if (m_Callback != nullptr)
        {
            m_Callback(m_Id);
        }
    }

    const int m_Id;
    // とりあえずラベルのみ
    glv::Label m_Label;
    std::function<void(int id)> m_Callback;
};

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
