﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include "DevMenu_ErrorListScene.h"


namespace devmenu { namespace cloudbackup {

/**************************************
class ErrorListScene
**************************************/
ErrorListScene::ErrorListScene(ParentPageInterface* pParentPage, const glv::Rect& rect) NN_NOEXCEPT
    : Scene(rect)
    , m_pParentPage(pParentPage)
{
    m_pButtonBack = new Button("< Back",
        [&]
        {
            m_pParentPage->SwitchScene(SceneType_CloudBackupRoot, true);
        }
        , glv::Rect(DefaultButtonWidth, DefaultButtonHeight));

    m_pButtonAllDelete = new Button("Delete All",
        [&]
        {
            // TODO 全て削除
        }
        , glv::Rect(DefaultButtonWidth, DefaultButtonHeight));
    m_pButtonAllDelete->pos(0.0f, m_pButtonBack->bottom());

    // ダミーリスト///////////////////////////////////////////////////////
    ScrollableBoxView* pBox = new ScrollableBoxView("x", glv::Rect(rect.width(), rect.height() - m_pButtonAllDelete->bottom()));
    pBox->pos(0.0f, m_pButtonAllDelete->bottom());
    pBox->enable(glv::Property::KeepWithinParent);
    const int maxErrorCount = 15;
    for (int i = 0; i < maxErrorCount; i++)
    {
        std::string errorName = std::string("Error") + std::to_string(i);

        auto pErrorView = new cloudbackup::ErrorView(
            glv::Rect(pBox->width() - 100.0f, 35.0f),
            [&](int id)
            {
                // TODO:モーダルを表示予定
            }
            , ErrorItem
            {
                i, errorName
            }
            );
        *pBox << pErrorView;
    }

    pBox->ArrangeTable();
    *this << pBox;
    // ダミーリスト///////////////////////////////////////////////////////

    *this << m_pButtonBack;
    *this << m_pButtonAllDelete;

    SetFirstFocusTargetView(m_pButtonBack);
}

void ErrorListScene::Refresh() NN_NOEXCEPT
{
    ClearRefreshRequest();
    // TODO:後ほど処理記載予定
}

/**
* 描画前コールバック
*/
void ErrorListScene::OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT
{
    if (IsRefreshRequired())
    {
        Refresh();
    }
}

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
