﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DevMenu_ApplicationsConfig.h"
#include "DevMenu_ApplicationsUiPolicy.h"
#include "../Common/DevMenu_CommonScene.h"
#include "../DevMenu_Common.h"

#include <atomic>
#include <glv_ScissorBoxView.h>
#include <glv/detail/glv_GfxTextApi.h>

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include "../Common/DevMenu_CommonScrollBox.h"

namespace devmenu { namespace application {

// DevMenu_ApplicationsSceneDetail.h との相互参照を防ぐためのクラス参照
class CatalogScene;

class DetailScene
    : public Scene
{
public:
    DetailScene( Page* pParentPage, const AbstractOperators& op, const glv::Rect& rect ) NN_NOEXCEPT;
    ~DetailScene() NN_NOEXCEPT;

    void OnLoopBeforeSceneRenderer( glv::ApplicationLoopContext& context, const glv::HidEvents& events ) NN_NOEXCEPT;

    glv::View* GetPrimaryView() NN_NOEXCEPT;
    void SetApplicationView( const nn::ns::ApplicationView& view ) NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;
    void Refresh() NN_NOEXCEPT;

private:
    class ButtonsTop : public glv::View
    {
    public:
        ButtonsTop( const AbstractOperators& op, DetailScene& parent, const glv::Rect& rect ) NN_NOEXCEPT;
        void Clear() NN_NOEXCEPT;
        void Update() NN_NOEXCEPT;
        glv::View& GetButton() NN_NOEXCEPT { return m_BackButton; }

    private:
        const AbstractOperators& m_Op;
        DetailScene&             m_Parent;
        devmenu::Button          m_BackButton;
        glv::Table               m_Table;
    };

private:
    class IconButtons : public glv::View
    {
    public:
        IconButtons( const AbstractOperators& op, DetailScene& parent, const glv::Rect& rect ) NN_NOEXCEPT;
        void Clear() NN_NOEXCEPT;
        void Update( bool isLaunchButtonOnly ) NN_NOEXCEPT;
        void UpdateLaunchButtonFocusable( bool isFocusable ) NN_NOEXCEPT;
        void UpdateApplicationIcon( const Buffer& iconBuffer ) NN_NOEXCEPT;
        void ClearApplicationIcon() NN_NOEXCEPT;

    private:
        static const glv::Rect LaunchButtonRect;
        static const glv::Rect DeleteButtonRect;
        static const glv::Rect LegalInfoButtonRect;

    private:
        void UpdateLaunchButton( bool isLaunchableCheckRequired ) NN_NOEXCEPT;
        void UpdateLegalInfoButton() NN_NOEXCEPT;
        void ShowLegalInfo() NN_NOEXCEPT;

    private:
        const AbstractOperators& m_Op;
        DetailScene&             m_Parent;
        devmenu::Button          m_LaunchButton;
        devmenu::Button          m_ManageButton;
        devmenu::Button          m_LegalInfoButton;
        glv::Table               m_Table;
        ApplicationIcon          m_Icon;
    };

    /** Detail ---------------------------------------------------------------------
     */
    class Detail : public glv::View
    {
    public:
        enum LabelTypesApplicationInfo
        {
            LabelTypesApplicationInfo_Size,

            LabelTypesApplicationInfo_NumElements
        };

        enum LabelTypesMetaInfo
        {
            LabelTypesMetaInfo_ApplicationTitle,
            LabelTypesMetaInfo_Publisher,
            LabelTypesMetaInfo_ApplicationId,
            LabelTypesMetaInfo_VersionNumber,
            LabelTypesMetaInfo_SaveDataSize,
            LabelTypesMetaInfo_SupportedLanguages,
            LabelTypesMetaInfo_NumElements
        };

    public:
        Detail( DetailScene& parent, const glv::Rect& rect ) NN_NOEXCEPT;
        virtual ~Detail() NN_NOEXCEPT;

        void Clear() NN_NOEXCEPT;
        const nn::Result Update() NN_NOEXCEPT;

    private:
        static const glv::Label::Spec DefalutLabelSpec;
        static const glv::Label::Spec InfoLabelSpecDefault;

    private:
        const nn::Result GetApplicationInfo() NN_NOEXCEPT;
        float GetTitleLabelWidthMax() NN_NOEXCEPT;
        const nn::Result SetLabelInfo() NN_NOEXCEPT;
        void SetLabelApplicationInfoField( float titleLabelWidth ) NN_NOEXCEPT;
        void SetLabelMetaInfoField( float titleLabelWidth ) NN_NOEXCEPT;
        const glv::WideString GenerateSupportedLanguagesStr( const nn::ns::ApplicationControlProperty& property ) NN_NOEXCEPT;
        void AddElementsToMainTable() NN_NOEXCEPT;
        void RemoveAllMainTableElements() NN_NOEXCEPT;

    private:
        DetailScene& m_Parent;
        glv::Table   m_Table;

        ScrollableBoxView m_DetailsScrollView;
        glv::Table  m_ApplicationInfoTable;
        glv::Table  m_MetaInfoTable;

        glv::Label* m_pLabelApplicationInfoTitle[ LabelTypesApplicationInfo_NumElements ];
        glv::Label* m_pLabelApplicationInfoField[ LabelTypesApplicationInfo_NumElements ];
        glv::Label* m_pLabelMetaInfoTitle[ LabelTypesMetaInfo_NumElements ];
        glv::Label* m_pLabelMetaInfoField[ LabelTypesMetaInfo_NumElements ];

        glv::Label      m_LabelMetadataHeader;
        glv::Label      m_LabelApplicationInfoHeader;
        glv::Style      m_StyleHeader;
        glv::Divider    m_DividerMetadataInfoHeader;
        glv::Divider    m_DividerApplicatonInfoHeader;
        Spacer          m_TableSpacer;

        glv::WideString m_StringsApplicationInfoField[ LabelTypesApplicationInfo_NumElements ];
        glv::WideString m_StringsMetaInfoField[ LabelTypesMetaInfo_NumElements ];
    };

private:
    /** DetailScene ---------------------------------------------------------------------
    */
    glv::Table                m_Base;
    Detail                    m_Detail;
    ButtonsTop                m_ButtonsTop;
    IconButtons               m_IconButtons;
    nn::ns::ApplicationView   m_ApplicationView;
    const AbstractOperators&  m_Op;
};

}} // ~namespace devmenu::application, ~namespace devmenu

