﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ae.h>
#include <nn/ns/ns_FactoryResetApi.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Result.h>
#include <nn/init.h>
#include <nn/os.h>

namespace {

const size_t HeapByteSize = 64 * 1024 * 1024;
const size_t MallocBytesSize = 32 * 1024 * 1024;

void SystemAppletFunction(nn::ae::SystemAppletParameters*) NN_NOEXCEPT
{
    NN_LOG("[DevMaintenanceMenu] Begin\n");

    if (nn::ae::GetBootMode() != nn::ae::BootMode_Maintenance)
    {
        NN_LOG("[DevMaintenanceMenu] Do nothing since boot mode is not maintenance\n");
        return;
    }

    nn::ns::Initialize();

    NN_LOG("[DevMaintenanceMenu] Reset to factory settings without user savedata\n");
    nn::ns::ResetToFactorySettingsWithoutUserSaveData();

    NN_LOG("[DevMaintenanceMenu] Reset to factory settings\n");
    nn::ns::ResetToFactorySettings();

    NN_LOG("[DevMaintenanceMenu] End\n");
}

}   // namespace

extern "C" void nninitStartup()
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::SetMemoryHeapSize(HeapByteSize));
    uintptr_t address;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::AllocateMemoryBlock(&address, MallocBytesSize));
    nn::init::InitializeAllocator(reinterpret_cast<void*>(address), MallocBytesSize);
}

extern "C" void nnMain()
{
    nn::ae::InvokeSystemAppletMain(nn::ae::AppletId_SystemAppletMenu, SystemAppletFunction);

    while (NN_STATIC_CONDITION(true))
    {
        nn::os::SleepThread(nn::TimeSpan::FromDays(1));
    }
}
