﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <sstream>
#include <iostream>
#include <iomanip>
#include <cstdlib>
#include <string>
#include <list>
#include <unordered_map>
#include <cerrno>
#include <algorithm>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/fs.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/nn_ApplicationId.h>
#include <nn/fs/fs_SaveDataManagement.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include <nn/fs/fs_BcatSaveData.h>
#include <nn/fs/fs_SystemSaveDataPrivate.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/htc/htc_Api.h>
#include "DevKitUpdater.h"

namespace {
#if !defined(USE_MALLOC)
    const size_t MemoryHeapSize = 12 * 1024 * 1024;
    nn::lmem::HeapHandle HeapHandleForSaveData;
    uint8_t HeapBuffer[MemoryHeapSize];
#endif
}

::nn::Result InitilizeHeap()
{
    nn::Result result;

#if !defined(USE_MALLOC)
    HeapHandleForSaveData = nn::lmem::CreateExpHeap(HeapBuffer,
                                                    MemoryHeapSize,
                                                    nn::lmem::CreationOption_DebugFill);
                                                    // nn::lmem::CreationOption_NoOption);
    if(HeapHandleForSaveData == nullptr)
    {
        ERROR_S("Create heap for save data FAILED.");
        return ResultApplicationError();
    }
#endif

    return nn::ResultSuccess();
}

void FinalizeHeap()
{
#if !defined(USE_MALLOC)
    if(HeapHandleForSaveData != nullptr)
    {
        nn::lmem::DestroyExpHeap(HeapHandleForSaveData);
    }
#endif
}
