﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <string>
#include <nn/nn_Assert.h>
#include <nn/nn_Macro.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/hid/debug/hid_UniquePad.h>
#include <nn/os/os_Thread.h>
#include <nn/nn_TimeSpan.h>

#include "ControllerSerialFlashTool_ErrorCode.h"

bool GetUniquePad(nn::hid::system::UniquePadId* pOutValue) NN_NOEXCEPT
{
    nn::hid::system::UniquePadId uniquePadIds[nn::hid::system::UniquePadIdCountMax];

    NN_LOG("[Serial Flash Tool] Waiting for controller to be connceted. Connect controller and press button\n");
    while (NN_STATIC_CONDITION(true))
    {
        auto count = nn::hid::system::ListUniquePads(uniquePadIds, NN_ARRAY_SIZE(uniquePadIds));

        if (count == 1)
        {
            break;
        }

        if (count > 1)
        {
            PrintError("More than 2 controllers are connected\n");
            return false;
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));
    }
    *pOutValue = uniquePadIds[0];
    return true;
}

bool AppendOutputFileName(std::string* pOutValue, const nn::hid::system::UniquePadId& id) NN_NOEXCEPT
{
    nn::bluetooth::Address address;
    if (nn::hid::system::GetUniquePadBluetoothAddress(&address, id).IsFailure())
    {
        PrintError("Failed reading Bluetooth Address from device\n");
        return false;
    }

    pOutValue->push_back('\\');
    for (auto& value : address.address)
    {
        char addrChar[2];
        sprintf(addrChar, "%02x", value);
        pOutValue->append(addrChar);
    }
    pOutValue->append(".csv");
    return true;
}
