﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_UniquePad.h>

#include "ControllerSerialFlashTool_Csv.h"
#include "ControllerSerialFlashTool_SerialFlashMap.h"

//!< 読み込む CSV の列の数
const int CsvRowCount = 3;
//!< 読み込む CSV の行の最大数
const int CsvLineCountMax = NN_ARRAY_SIZE(SerialFlashMap);

//!< Csv のデータが読み込まれるフォーマット
typedef StringTable<CsvRowCount, CsvLineCountMax> SerialFlashCsvType;

//!< SerialFlash の内容を読み出し CSV で出力可能なテキスト形式で取得します
bool ReadSerialFlashAsCsvText(SerialFlashCsvType* pOutValue, const nn::hid::system::UniquePadId& id) NN_NOEXCEPT;

//!< SerialFlash の内容を読み出し CSV で出力可能なテキスト形式で取得します
bool WriteSerialFlashFromCsv(const SerialFlashCsvType& input, const nn::hid::system::UniquePadId& id) NN_NOEXCEPT;

