﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_MathTypes.h>

/**
 * @brief   色を表す型です。
 */
typedef nn::util::Color4u8Type Color;

/**
 * @brief   汎用的な色を定義した静的クラスです。
 */
class Colors
{
public:
    static const Color IndianRed;
    static const Color LightCoral;
    static const Color Salmon;
    static const Color DarkSalmon;
    static const Color LightSalmon;
    static const Color Crimson;
    static const Color Red;
    static const Color FireBrick;
    static const Color DarkRed;
    static const Color Pink;
    static const Color LightPink;
    static const Color HotPink;
    static const Color DeepPink;
    static const Color MediumVioletRed;
    static const Color PaleVioletRed;
    static const Color Coral;
    static const Color Tomato;
    static const Color OrangeRed;
    static const Color DarkOrange;
    static const Color Orange;
    static const Color Gold;
    static const Color Yellow;
    static const Color Violet;
    static const Color Indigo;
    static const Color GreenYellow;
    static const Color Lime;
    static const Color Green;
    static const Color Cyan;
    static const Color SkyBlue;
    static const Color Blue;
    static const Color Cornsilk;
    static const Color Wheat;
    static const Color Brown;
    static const Color White;
    static const Color Snow;
    static const Color Ivory;
    static const Color Silver;
    static const Color Gray;
    static const Color Black;

    /**
     * @brief   アルファ値に補正をかけた色を取得します。
     */
    static Color GetAlphaColor(const Color& color, uint8_t alpha) NN_NOEXCEPT
    {
        auto newColor = color;
        newColor.v[3] = static_cast<uint8_t>(color.v[3] * alpha / 255);
        return newColor;
    }

private:
    Colors();   // インスタンス生成を禁止
};
