﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Base/BcatTestApp_Glv.h"

namespace app
{
    const RectanglePosition Position_Dialog = { 310, 240, 970, 420 };

    const int DrawPriority_Dialog = 8000;

    // ダイアログ(Caution)のフレームと背景色
    const int DrawColorSet_DialogCautionFrame = app::ColorSet_Red;
    const int DrawColorSet_DialogCautionBack  = 0x660000ff;

    // ダイアログ(YesNo)のフレームと背景色
    const int DrawColorSet_DialogYesNoFrame = app::ColorSet_Yellow;
    const int DrawColorSet_DialogYesNoBack  = 0x66661aff;

    // ダイアログ(Notice)のフレームと背景色
    const int DrawColorSet_DialogNoticeFrame = app::ColorSet_Blue;
    const int DrawColorSet_DialogNoticeBack  = 0x1a1a99ff;

    // ダイアログの Yes/No 時の選択・非選択文字色
    const int DrawColorSet_DialogSelected    = app::ColorSet_White;
    const int DrawColorSet_DialogNotSelected = app::ColorSet_DarkWhite;

    // ダイアログの「?」マーク
    const int DrawColorSet_DialogQuestionMark = 0xffcc00ff;

    // ダイアログの「!」マーク
    const int DrawColorSet_DialogExclamationMark1 = app::ColorSet_Red;
    const int DrawColorSet_DialogExclamationMark2 = app::ColorSet_Yellow;

    // ダイアログの「i」マーク
    const int DrawColorSet_DialogInformationMark = 0xccccffff;

    extern ExecCallbackGroup ExecDialogGroup;

    struct DialogParam
    {
        static const int messageLenMax = 256;
        static const int consoleSizeX = 100;
        static const int consoleSizeY = 6;

        enum InfoType
        {
            InfoType_Caution = 0,
            InfoType_YesNo,
            InfoType_Notice,
        };
        enum StartPosition
        {
            StartPosition_No = 0,
            StartPosition_Yes = 1
        };

        char dialogMessage[ messageLenMax ];
        char16_t dialogMessage16[ messageLenMax ];
        nn::Result result;
        bool isResultSet;
        InfoType infoType;
        StartPosition startPosition;
        int delayFrame;

        // コンソール
        app::FixedProportionalConsole<char16_t>* pConsole16;
        char* pConsoleBuffer;

        DialogParam()  NN_NOEXCEPT :
            isResultSet( false ),
            infoType( InfoType_Caution ),
            startPosition( StartPosition_No ),
            delayFrame( 0 ),
            pConsole16( nullptr ),
            pConsoleBuffer( nullptr )
        {
            dialogMessage[0] = '\0';
            dialogMessage16[0] = u'\0';
        }

    public:
        void SetMessage( const char* pMessage ) NN_NOEXCEPT
        {
            std::strncpy( dialogMessage, pMessage, messageLenMax - 1 );
            dialogMessage[ messageLenMax - 1 ] = '\0';
        }
        void SetMessage16( const char16_t* pMessage ) NN_NOEXCEPT
        {
            size_t len = app::StrLen16( pMessage );
            std::memcpy( dialogMessage16, pMessage, sizeof(char16_t) * ( len + 1 ) );
            dialogMessage16[ messageLenMax - 1 ] = u'\0';
        }
        void SetResult( nn::Result r ) NN_NOEXCEPT
        {
            result = r;
            isResultSet = true;
        }

        void SetStartPosition( StartPosition pos ) NN_NOEXCEPT
        {
            startPosition = pos;
        }

        app::FixedProportionalConsole<char16_t>* GetConsole() NN_NOEXCEPT
        {
            return pConsole16;
        }

        void SetReturnDelay( int count ) NN_NOEXCEPT
        {
            delayFrame = count;
        }
    };

    struct DialogReturnParam
    {
        enum SelectedItem
        {
            SelectedItem_No = 0,
            SelectedItem_Yes = 1
        };

        bool selectedItem;

    public:
        bool IsSelectedYes() NN_NOEXCEPT
        {
            return (selectedItem == SelectedItem_Yes);
        }
        bool IsSelectedNo() NN_NOEXCEPT
        {
            return (selectedItem == SelectedItem_No);
        }
    };

    DialogParam* AllocDialogParam( DialogParam::InfoType infoType ) NN_NOEXCEPT;
}
