﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "BcatSystemDebugTool_Common.h"
#include "BcatSystemDebugTool_TopMenu.h"

namespace app
{
void ExecOtherMenu_Initialize( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT;
void ExecOtherMenu           ( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT;
void ExecOtherMenu_Finalize  ( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT;
void DrawOtherMenu( void* arg ) NN_NOEXCEPT;

ExecCallbackGroup ExecOtherMenuGroup = {
    ExecOtherMenu_Initialize,
    ExecOtherMenu,
    ExecOtherMenu_Finalize,
    nullptr,

    DrawOtherMenu,
    nullptr,
    DrawPriority_OtherMenu,
    0
};

//----------------------------------------------------------------
namespace
{
    app::Menu g_Menu;
    enum
    {
        MenuIndex_RemoveUser = 0,
        MenuIndex_SwitchLanguage,
        MenuIndex_Back,
    };
    int g_InitialMenuIndex = MenuIndex_Back;
    const int MenuMax = MenuIndex_Back + 1;
} // namespace

//----------------------------------------------------------------
// その他メニュー用描画コールバック
//
void DrawOtherMenu( void* arg ) NN_NOEXCEPT
{
}

//----------------------------------------------------------------
// その他メニューのメニュー文字列描画
//
namespace
{
void DrawOtherMenuItems() NN_NOEXCEPT
{
    app::FixedProportionalConsole<char16_t>* p = g_Menu.GetConsole16();
    if ( p )
    {
        // "-- その他 --"
        p->PrintfEx( 1, 0,
                     app::ConsoleColor_White,
                     GetText( TextResource_OtherMenuTitle ) );

        // "ユーザの選択を解除する"
        p->PrintfEx( 2, 2 + MenuIndex_RemoveUser,
                     app::IsUserValid() ? app::ConsoleColor_White: app::ConsoleColor_DarkWhite,
                     GetText( TextResource_CancelUserSelect ) );
        // 言語を切り替える
        p->PrintfEx( 2, 2 + MenuIndex_SwitchLanguage,
                     app::ConsoleColor_White,
                     GetText( TextResource_SwitchLanguage ) );
        // 戻る
        p->PrintfEx( 2, 2 + MenuIndex_Back,
                     app::ConsoleColor_White,
                     GetText( TextResource_BackFromOtherMenu ) );
    }
}

//----------------------------------------------------------------
// その他メニューのキー説明
void PrintOtherMenuHelp() NN_NOEXCEPT
{
    app::GetHelpConsole().Clear();
    app::GetHelpConsole().PrintfEx( 2, 0, GetText( TextResource_HelpOtherMenu ) );
}

//----------------------------------------------------------------
// ユーザ選択の解除
//
void RemoveUser() NN_NOEXCEPT
{
    if ( ! app::IsUserValid() )
    {
        return;
    }

    app::ForgetUser();


    // "ユーザ選択を解除しました。"
    const char16_t* pMessage[] = { GetText( TextResource_CancelUserSelectDone ) };
    app::SetNoticeDialog( pMessage, 1 );
}

} // namespace

//----------------------------------------------------------------
// その他メニュー(開始処理)
//
void ExecOtherMenu_Initialize( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    // メニュー作成
    g_Menu.CreateConsole( app::ConsoleSize_Char16_t, app::Position_OtherMenu, 80, 5, 1, 2, 24, 4, DrawPriority_OtherMenu + 1, 0 );
    g_Menu.SetBackColor( app::DrawColorSet_OtherMenuBack, app::DrawColorSet_OtherMenuFrame, app::DrawFrameWidth );
    g_Menu.SetItemParameter( MenuMax, g_InitialMenuIndex );

    DrawOtherMenuItems();

    // キー説明
    PrintOtherMenuHelp();
}
//----------------------------------------------------------------
// その他メニュー(終了処理)
//
void ExecOtherMenu_Finalize( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    g_Menu.DestroyConsole();
}

//----------------------------------------------------------------
// その他メニュー
//
void ExecOtherMenu( const glv::HidEvents& events, void* arg ) NN_NOEXCEPT
{
    g_Menu.SetHidEvent( &events );
    g_Menu.Update();

    switch( g_Menu.CheckButtonOk() )
    {
        case MenuIndex_RemoveUser:
            {
                // ユーザ選択の解除
                RemoveUser();
                return;
            }
            break;
        case MenuIndex_SwitchLanguage:
            {
                app::GetSystemConsole().Printf( "Change Language to %s\n", IsEnglish()? "Japanese": "English" );
                app::SetEnglish( ! IsEnglish() );
                PrintOtherMenuHelp();
                return;
            }
            break;
        case MenuIndex_Back:
            {
                app::sequence::JumpTo( ExecTopMenuGroup );
                return;
            }
            break;
        default:
            break;
    }

    // B ボタンで戻る
    if ( g_Menu.CheckButtonCancel() )
    {
        app::sequence::JumpTo( ExecTopMenuGroup );
    }

    if ( g_Menu.IsUpdated() )
    {
        DrawOtherMenuItems();
        g_Menu.ClearUpdated();
    }
}
} //namespace app


