﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/bcat_DeliveryCacheDirectory.h>
#include <nn/bcat/bcat_DeliveryCacheFile.h>

namespace app
{
    // 描画コールバック優先度(小さいほど先)
    enum DrawPriority
    {
        DrawPriority_BaseFrame = 10,
        DrawPriority_TopMenu = 30,
        DrawPriority_SubMenu = 30,
        DrawPriority_NetworkConnection = 100,
        DrawPriority_SaveAllFile = 200,
        DrawPriority_OtherMenu = 200,
        DrawPriority_Dump = 1100,
    };

    enum DrawColorSet
    {
        // タイトルのフレームと背景色
        DrawColorSet_TitleFrame       = app::ColorSet_Yellow,
        DrawColorSet_TitleBack        = 0x408080ff,

        // トップメニューのフレームと背景色
        DrawColorSet_TopMenuFrame       = app::ColorSet_White,
        DrawColorSet_TopMenuBack        = 0x06630ff,

        // ベースのフレーム色
        DrawColorSet_BaseFrame         = app::ColorSet_Black,

        // アプリリストフレームと背景色
        DrawColorSet_AppListFrame      = app::ColorSet_White,
        DrawColorSet_AppListBack       = 0x484800ff,

        // 項目選択用カーソル背景色
        DrawColorSet_ItemCursorBack    = 0x488080ff,

        // 進捗バーフレームと背景色
        DrawColorSet_ProgressBarFrame  = 0xb0b0b0ff,
        DrawColorSet_ProgressBar       = 0xe5e54cff,

        // ファイル進捗表示の背景色
        DrawColorSet_FileProgressBack  = 0x0000cc99,

        // ファイル一覧のフレームと背景色
        DrawColorSet_FileMenuFrame     = app::ColorSet_White,
        DrawColorSet_FileMenuBack      = 0x004c4cff,

        // プッシュ通知一覧のフレームと背景色
        DrawColorSet_PushNotificationLogFrame = 0x99ffffff,
        DrawColorSet_PushNotificationLogBack  = 0x4c0066ff,

        // バイナリダンプのフレームと背景色
        DrawColorSet_BinaryDumpFrame = app::ColorSet_White,
        DrawColorSet_BinaryDumpBack  = 0x004c4cff,

        // 汎用メニューのフレームと背景色
        DrawColorSet_MenuFrame = app::ColorSet_White,
        DrawColorSet_MenuBack  = 0x006630ff,

        // その他メニューのフレームと背景色
        DrawColorSet_OtherMenuFrame = 0xf8e840ff,
        DrawColorSet_OtherMenuBack  = 0x606040ff,

        // ネットワーク接続切り替えのフレームと背景色
        DrawColorSet_NetworkConnectionFrame = 0x80ffffff,
        DrawColorSet_NetworkConnectionBack  = 0x40a0a0ff,

    };

    const float DrawFrameWidth = 3.0F;

    // 各メニューウィンドウの位置( x1, y1, x2, y2 )
    const RectanglePosition Position_Title = { 340, 120, 940, 190 };
    const RectanglePosition Position_TopMenu = { 280, 210, 1000, 530 };
    const RectanglePosition Position_NetworkConnection = { 350, 280,  930, 450 };
    const RectanglePosition Position_AppList = { 70, 100, 1200, 616 };
    const RectanglePosition Position_AppListSubMenu = { 310, 250, 910, 400 };
    const RectanglePosition Position_AppListScrollBar = { 1190, 200, 1192, 604 };
    const RectanglePosition Position_BaseFrame = { 2, 2, 1278, 718 };
    const RectanglePosition Position_FileList = { 100, 100, 1170, 628 };
    const RectanglePosition Position_FileListScrollBar = { 1160, 220, 1162, 620 };
    const RectanglePosition Position_PushNotificationLog = { 70, 100, 1200, 608 };
    const RectanglePosition Position_PushNotificationLogScrollBar = { 1190, 200, 1192, 596 };
    const RectanglePosition Position_BinaryDump = { 70, 100, 1210, 620 };
    const RectanglePosition Position_BinaryDumpScrollBar = { 1200, 220, 1202, 594 };
    const RectanglePosition Position_SaveAllFile = { 70, 100, 1210, 620 };
    const RectanglePosition Position_SaveAllFileScrollBar = { 1200, 110, 1202, 610 };
    const RectanglePosition Position_OtherMenu = { 150, 200, 1130, 500 };

    // マウント時の名前
    static const char MountSaveDataName[] = "save";
    static const char MountSdCardName[] = "sd";
    // パス長最大値
    static const size_t PathLengthMax = sizeof(MountSaveDataName) + sizeof(nn::bcat::DirectoryName) + sizeof(nn::bcat::FileName) + 0x30;
    // "[sd or save]:/bcat/DeliveryCache/<appid=16char>/<dir=31char>/<file=31char>

    // セーブデータやデータ配信キャッシュ上のパス長最大値 (若干の余裕を含む)
    // "save:/<dir=31char>/<file=31char>" や "<dir=31char>/<file=31char>"
    static const size_t PathCfLengthMax = sizeof(MountSaveDataName) + sizeof(nn::bcat::DirectoryName) + sizeof(nn::bcat::FileName) + 3;

    // SD カード上のパス長最大値 (若干の余裕を含む)
    // "sd:/bcat/DeliveryCache/<appid=16char>/<dir=31char>/<file=31char>"
    static const size_t PathSdLengthMax = sizeof(MountSaveDataName) + sizeof(nn::bcat::DirectoryName) + sizeof(nn::bcat::FileName) + 0x30;

    // タイトル・バージョン
    static const char* TitleString = "BCAT SYSTEM DEBUG TOOL";
    static const int TitleStringFontSize = 24;
    static const char* VersionString = "ver 0.1.0";
    static const int VersionStringFontSize = 16;
}
