﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace app
{
    struct ApplicationMenuParam
    {
        int m_PositionX;
        int m_PositionY;
        uint64_t m_ApplicationId;
        bool m_IsTaskExist;
    };

    struct ApplicationMenuReturnParam
    {
        bool m_IsListDirectory;
        bool m_IsUnregisterTask;
        bool m_IsRequestSync;
        bool m_IsCancelSyncRequest;
        bool m_IsDumpToSdCard;
        bool m_IsClearStorage;
        bool m_IsCanceled;

        void ClearParam() NN_NOEXCEPT
        {
            m_IsListDirectory = false;
            m_IsUnregisterTask = false;
            m_IsRequestSync = false;
            m_IsCancelSyncRequest = false;
            m_IsDumpToSdCard = false;
            m_IsClearStorage = false;
            m_IsCanceled = false;
        }
    };

    extern ExecCallbackGroup ExecApplicationMenuGroup;
}
