﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/ncm/ncm_ContentMetaId.h>

#define USE_MALLOC
// #define SKIP_BACKUP_DEVMENU_SAVEDATA
// MEMO: SKIP_BACKUP_DEVICE_SAVEDATA は NN_BACKUPSAVEDATA_DEVICE が定義されていない場合のみ有効です
//       いずれ削除予定です
#if !defined(NN_BACKUPSAVEDATA_DEVICE)
#define SKIP_BACKUP_DEVICE_SAVEDATA
#endif

// enum ResultState {
//     SUCCESS,
//     FAILURE,
// };

#define ERROR_LOG(fmt, ...) NN_LOG(fmt, __VA_ARGS__)
#define ERROR_S(x)          ERROR_LOG("%s", x)

#define CUTFILEPATH(path)   (std::strrchr(path, '\\') ? std::strrchr(path, '\\') + 1 : path)

#define RETURN_IF_FAILED(rslt)      {::nn::Result rst = rslt;if(!rst.IsSuccess()){NN_LOG("error: %08x (%s:%d)\n",rst.GetInnerValueForDebug(),CUTFILEPATH(__FILE__),__LINE__);result = rst;return rst;}else{result = rst;}}
#define QUIT_IF_FAILED(rslt)        result = rslt;if(!result.IsSuccess()){NN_LOG("error: %08x (%s:%d)\n",result.GetInnerValueForDebug(),CUTFILEPATH(__FILE__),__LINE__);goto quit;}

#define SET_AND_CHECK_ALLCATION(variable, addr)       {variable = addr;if(variable == nullptr){ERROR_S("Heap allocation FAILED.\n");return ResultApplicationError();}}
#define SET_AND_CHECK_ALLCATION_QUIT(variable, addr)  {variable = addr;if(variable == nullptr){ERROR_S("Heap allocation FAILED.\n");goto quit;}}

NN_DEFINE_ERROR_RANGE_RESULT(ResultApplicationError, 500, 1, 2);
NN_DEFINE_ERROR_RANGE_RESULT(ResultNotFound, 500, 2, 3);

extern const std::string SaveDataInfoFileName;
extern const std::string BackupTypeStringPartial;

::nn::Result InitializeDirectories();
::nn::Result InitilizeHeap();
void FinalizeHeap();
::nn::Result ExportSaveDataAll(bool isExistAccountOnly = false);
::nn::Result ExportSaveDataPartial(std::string titleIds, bool isExistAccountOnly = false);
::nn::Result CreateDummySaveData();
::nn::Result ImportSaveDataAll(bool isReplaceAccount = false);
::nn::Result DumpSaveDataAll();

std::string EncodeToBackupFileName(std::string fileName);
std::string DecodeFromBackupFileName(std::string fileName);

#if defined(NN_BACKUPSAVEDATA_SYSTEM)
bool IsBackupTitleForSystem(nn::ncm::ApplicationId applicationId);
#endif

::nn::Result CreateConfigFile(std::string baseDirectoryPath, bool isPartial);
#if defined( NN_CUSTOMERSUPPORTTOOL )
::nn::Result CreateConfigFileToMemory(char* pOutBuffer, bool isPartial, int* pOutBufferSize);
#endif
::nn::Result ParseConfigFile(std::string baseDirectoryPath, std::string& backupType);
::nn::Result CreateSaveDataInfoFile(std::string baseDirectoryPath,
                                    std::string saveDataType, std::string saveDataUserIdH, std::string saveDataUserIdL,
                                    std::string applicationId, std::string saveDataSize,
                                    std::string ownerId, std::string saveDataFlags,
                                    std::string saveDataAvailableSize, std::string saveDataJournalSize,
                                    std::string saveDataSpaceId = "", std::string cacheStorageIndex = "");
#if defined( NN_CUSTOMERSUPPORTTOOL )
::nn::Result CreateSaveDataInfoFileToMemory(char* pOutBuffer,
                                    std::string saveDataType, std::string saveDataUserIdH, std::string saveDataUserIdL,
                                    std::string applicationId, std::string saveDataSize,
                                    std::string ownerId, std::string saveDataFlags,
                                    std::string saveDataAvailableSize, std::string saveDataJournalSize,
                                    int* pOutBufferSize,
                                    std::string saveDataSpaceId = "", std::string cacheStorageIndex = "");
#endif
::nn::Result ParseSaveDataInfoFile(std::string baseDirectoryPath,
                                    std::string& saveDataType, uint64_t& saveDataUserIdH, uint64_t& saveDataUserIdL,
                                    uint64_t& applicationId, uint64_t& saveDataSize,
                                    uint64_t& ownerId, uint32_t& saveDataFlags,
                                    uint64_t& availableSize, uint64_t& journalSize,
                                    uint32_t& saveDataSpaceId, int32_t& cacheIndex);
::nn::Result CreateAccountInfoFile(std::string baseDirectoryPath);
::nn::Result ParseAccountInfoFile(std::string baseDirectoryPath);

bool SetDevKitAccount(nn::fs::UserId userId);
bool SetBackuppedAccount(nn::fs::UserId userId);
bool SetBackuppedAccountVector(std::vector<nn::fs::UserId> accountvector);
nn::fs::UserId ConvertAccount(nn::fs::UserId userId);
::nn::Result GetAccountVectorFromDevkit();
int GetDevkitAccountNum();
nn::fs::UserId GetDevKitAccount(int index);
bool CheckDevkitAccountExist(nn::fs::UserId userId);
bool AccountNumCheck();
void DisplayConvertAccountInfo();
