﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio.h>
#include <nn/mem.h>

class ScopedDummyAudioRenderer
{
public:
    NN_IMPLICIT ScopedDummyAudioRenderer(nn::mem::StandardAllocator& allocator)
        : m_Allocator(allocator)
    {
        nn::audio::AudioRendererParameter parameter;
        nn::audio::InitializeAudioRendererParameter(&parameter);

        const auto workBufferSize = nn::audio::GetAudioRendererWorkBufferSize(parameter);
        m_WorkBuffer = m_Allocator.Allocate(workBufferSize, nn::os::MemoryPageSize);

        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::audio::OpenAudioRenderer(&m_Handle, parameter, m_WorkBuffer, workBufferSize));
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::audio::StartAudioRenderer(m_Handle));
    }

    ~ScopedDummyAudioRenderer()
    {
        nn::audio::StopAudioRenderer(m_Handle);
        nn::audio::CloseAudioRenderer(m_Handle);

        m_Allocator.Free(m_WorkBuffer);
    }

private:
    void* m_WorkBuffer;
    nn::audio::AudioRendererHandle m_Handle;
    nn::mem::StandardAllocator& m_Allocator;
};
