﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio.h>
#include <nn/mem.h>

class ScopedDummyAudioOut
{
public:
    ScopedDummyAudioOut()
    {
        nn::audio::AudioOutParameter parameter;
        nn::audio::InitializeAudioOutParameter(&parameter);
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::audio::OpenDefaultAudioOut(&m_AudioOut, parameter));
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::audio::StartAudioOut(&m_AudioOut));
    }

    ~ScopedDummyAudioOut()
    {
        nn::audio::StopAudioOut(&m_AudioOut);
        nn::audio::CloseAudioOut(&m_AudioOut);
    }

private:
    nn::audio::AudioOut m_AudioOut;
};
