﻿/*---------------------------------------------------------------------------*
  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#if NEED_330_EXTENSION
#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_enhanced_layouts : enable
#endif

#ifdef NN_GFX_VULKAN
#define GFXUTIL_LAYOUT_LOCATION( x ) layout( location = x )
#define GFXUTIL_LAYOUT_BINDING( x ) layout( binding = x )
#define GFXUTIL_BINDING( x ) binding = x,
#else
#define GFXUTIL_LAYOUT_LOCATION( x )
#define GFXUTIL_LAYOUT_BINDING( x )
#define GFXUTIL_BINDING( x )
#endif

layout(GFXUTIL_BINDING( 0 ) std140) uniform ShaderParam
{
    mat4 uUser;
    float uAlpha;
};

GFXUTIL_LAYOUT_LOCATION( 0 ) in vec3 aVertex;
GFXUTIL_LAYOUT_LOCATION( 1 ) in vec4 aColor;
GFXUTIL_LAYOUT_LOCATION( 2 ) in vec2 aTexCoord0;

out gl_PerVertex
{
    vec4 gl_Position;
};
layout(location = 0) out vec4 vColor;
layout(location = 1) out vec4 vTexCoord;

void main(void)
{
    const float COLOR_U8_TO_FLOAT = 1.0f / 255;

    gl_Position = vec4(aVertex, 1) * uUser;
    vColor = aColor * COLOR_U8_TO_FLOAT;
    vTexCoord = vec4(aTexCoord0, 0, 0);

    #ifdef NN_GFX_VULKAN
    gl_Position.y = -gl_Position.y;
    gl_Position.z = (gl_Position.z + gl_Position.w) / 2.0;
    #endif
}

