﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/os.h>
#include <nn/mem.h>
#include <nn/time.h>
#include <nn/time/time_Api.h>

#include "../../Libraries/capsrv/server/capsrvServer_Config.h"
#include "../../Libraries/capsrv/server/decodersrv_InitializeForDecoderServer.h"

//---------------
// ヒープ
//---------------
static const size_t HeapSize = 16 * 1024; // nn::sf で使う
NN_ALIGNAS(4096) char g_HeapMemory[HeapSize];

nn::mem::StandardAllocator g_Allocator;

extern "C" void* malloc(size_t size) NN_NOEXCEPT
{
    auto p = g_Allocator.Allocate(size);
    //ReportMemoryUsage();
    return p;
}

extern "C" void free(void* p) NN_NOEXCEPT
{
    if(p)
    {
        g_Allocator.Free(p);
    }
    //ReportMemoryUsage();
}

extern "C" void* calloc(size_t num, size_t size)
{
    size_t sum = num * size;
    void*  p   = malloc(sum);
    if (p)
    {
        std::memset(p, 0, sum);
    }
    return p;
}

extern "C" void* realloc(void* p, size_t newSize)
{
    void* q = g_Allocator.Reallocate(p, newSize);
    //ReportMemoryUsage();
    return q;
}

extern "C" void* aligned_alloc(size_t alignment, size_t size)
{
    void* p = g_Allocator.Allocate(size, alignment);
    //ReportMemoryUsage();
    return p;
}


//---------------

extern "C" void nninitStartup() NN_NOEXCEPT
{
    // 空実装にする
}

extern "C" void nndiagStartup() NN_NOEXCEPT
{
    // 空実装にする
}

extern "C" void nnMain() NN_NOEXCEPT
{
    g_Allocator.Initialize(g_HeapMemory, HeapSize);

    NN_CAPSRV_LOG_INFO("Starting jpegdec server\n");
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(jpegdec, MainThread));
    nn::os::ChangeThreadPriority(nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_PRIORITY(jpegdec, MainThread));

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::capsrv::server::InitializeForDecoderServer());

    //---------
    // メインスレッドで処理する
    nn::capsrv::server::DecoderControlServerThreadFunction(nullptr);
    //---------

    nn::capsrv::server::FinalizeForDecoderServer();

    NN_CAPSRV_LOG_INFO("Exiting jpegdec server\n");
}
