﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include <nn/nn_Common.h>
#include <nn/util/util_FormatString.h>

#include "DummyStarter_Processor.h"

class RootView : public glv::View
{
public:
    RootView( const unsigned width, const unsigned height) NN_NOEXCEPT;

    ~RootView() NN_NOEXCEPT;

    virtual const char *className() const { return "RootView"; };
    virtual void onDraw(glv::GLV& g);

    static const int PaddingLeft = 20;
    static const int PaddingTop = 60;
    static const int LineSpace = 40;

    void SetProcessor(Processor* pProcessor)
    {
        m_pProcessor = pProcessor;
    }

private:
    Processor* m_pProcessor;
};
