﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DummyStarter_RootView.h"

RootView::RootView(const unsigned width, const unsigned height) NN_NOEXCEPT
    : glv::View(glv::Rect(width, height))
{
    //disable(glv::Property::DrawBack | glv::Property::DrawBorder | glv::Property::HitTest);
}

RootView::~RootView() NN_NOEXCEPT
{
    // nothing special
}

void RootView::onDraw(glv::GLV& g)
{
    char str[256];

    // Char color = white
    glv::draw::color(1.0, 1.0, 1.0);

    for (int i = 0; i < Processor::Stage_Count; i++)
    {
        const auto stage = static_cast<Processor::Stage>(i);
        const auto status = m_pProcessor->GetStatus(stage);
        const int x = PaddingLeft;
        const int y = PaddingTop + i * LineSpace;

        nn::util::SNPrintf(str, sizeof(str), "%s: %s", Processor::GetStageText(stage), Processor::GetStatusText(status));
        glv::draw::text(str, x, y, LineSpace);
    }

}
