﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_ShowArgYouTubeVideo.h>

#include <string>
#include <nn/applet/applet_Types.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
ShowYouTubeVideoArg::ShowYouTubeVideoArg() NN_NOEXCEPT
: m_Data()
{
    // 初期化
    common::CommonArgData::InitializeData(m_Data, common::ShimKind::Web);

    // デフォルトでアノニマスモードにする
    const bool isAnonymousMode = true;
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsAnonymousMode, isAnonymousMode);

    // デフォルトで BootAsYouTubePlayer を true にする。
    const bool bootAsYouTubePlayer = true;
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootAsYouTubePlayer, bootAsYouTubePlayer);

    // デフォルトで BootAsMediaPlayer を true にする。
    const bool bootAsMediaPlayer = true;
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootAsMediaPlayer, bootAsMediaPlayer);
}

//------------------------------------------------------------------------
ShowYouTubeVideoArg::ShowYouTubeVideoArg(const char* pRequestUrl) NN_NOEXCEPT
: ShowYouTubeVideoArg()
{
    // リクエストURLをセット
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::RequestURL, RequestUrlMaxLength, pRequestUrl);
}

//------------------------------------------------------------------------
void ShowYouTubeVideoArg::SetBootDisplayKind(const WebBootDisplayKind bootDisplayKind) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootDisplayKind, common::BootDisplayKind(bootDisplayKind));
}

//------------------------------------------------------------------------
void ShowYouTubeVideoArg::SetMediaPlayerAutoCloseEnabled(const bool autoCloseEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::MediaPlayerAutoCloseEnabled, autoCloseEnabled);
}

//------------------------------------------------------------------------
void ShowYouTubeVideoArg::SetMediaPlayerSpeedControlEnabled(const bool mediaPlayerSpeedControlEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::MediaPlayerSpeedControlEnabled, mediaPlayerSpeedControlEnabled);
}

//------------------------------------------------------------------------
void ShowYouTubeVideoArg::SetBootAsWebPage(const bool bootAsWebPage) NN_NOEXCEPT
{
    // WebPage として開きたい場合は bootAsMediaPlayer を false とします。
    // @refs BROWSER1-1533#Comment-2448926
    const bool bootAsMediaPlayer = !bootAsWebPage;
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootAsMediaPlayer, bootAsMediaPlayer);
}

//------------------------------------------------------------------------
const uint8_t* ShowYouTubeVideoArg::Data() const NN_NOEXCEPT
{
    return m_Data;
}

}} // namespace nn::web
