﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_ShowArg.h>

#include <string>
#include <nn/applet/applet_Types.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>

namespace nn { namespace web {

// enum値一致のチェック
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_EndButtonPressed) == static_cast<int>(web::common::ExitReason::EndButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_BackButtonPressed) == static_cast<int>(web::common::ExitReason::BackButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_ExitMessage) == static_cast<int>(web::common::ExitReason::ExitMessage));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_CallbackUrlReached) == static_cast<int>(web::common::ExitReason::CallbackUrlReached));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_LastWindowDeleted) == static_cast<int>(web::common::ExitReason::LastWindowDeleted));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_LocalNetworkDisconnectionDenied) == static_cast<int>(web::common::ExitReason::LocalNetworkDisconnectionDenied));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_MediaPlayerClosed) == static_cast<int>(web::common::ExitReason::MediaPlayerClosed));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_CausedByWebPage) == static_cast<int>(web::common::ExitReason::CausedByWebPage));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_UserSelectionCanceled) == static_cast<int>(web::common::ExitReason::UserSelectionCanceled));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_NetworkConnectionFailed) == static_cast<int>(web::common::ExitReason::NetworkConnectionFailed));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_SystemUpdateRequired) == static_cast<int>(web::common::ExitReason::SystemUpdateRequired));
NN_STATIC_ASSERT(static_cast<int>(WebExitReason_Unexpected) == static_cast<int>(web::common::ExitReason::Unexpected));

//------------------------------------------------------------------------
ShowWebPageArg::ShowWebPageArg() NN_NOEXCEPT
: m_Data()
{
    // 初期化
    common::CommonArgData::InitializeData(m_Data, common::ShimKind::Web);

    // デフォルトでアノニマスモードにする
    const bool isAnonymousMode = true;
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsAnonymousMode, isAnonymousMode);
}

//------------------------------------------------------------------------
ShowWebPageArg::ShowWebPageArg(const char* pRequestUrl) NN_NOEXCEPT
: ShowWebPageArg()
{
    // リクエストURLをセット
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::RequestURL, RequestUrlMaxLength, pRequestUrl);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetBootAsMediaPlayer(bool bootAsMediaPlayer) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootAsMediaPlayer, bootAsMediaPlayer);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetCallbackUrl(const char* pCallbackUrl) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::CallbackURL,
        CallbackUrlMaxLength, pCallbackUrl);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetCallbackableUrl(const char* pCallbackableUrl) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::CallbackableURL,
        CallbackableUrlMaxLength, pCallbackableUrl);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetPointerEnabled(const bool pointerEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UseStickPointer, pointerEnabled);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetLeftStickMode(const WebLeftStickMode mode) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::LeftStickMode, common::LeftStickMode(mode));
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetUid(const nn::account::Uid& uid) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::Uid, uid);

    // 有効なUidだったらアカウントモード(非アノニマス)にし
    // 無効なUidだったらアノニマスモードにする
    const bool isAnonymousMode = (uid == ::nn::account::InvalidUid);
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::IsAnonymousMode, isAnonymousMode);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetFooterFixedKind(const WebFooterFixedKind webFooterFixedKind) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::FooterFixedKind, common::FooterFixedKind(webFooterFixedKind));
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetBackgroundKind(const WebBackgroundKind kind) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BackgroundKind, common::BackgroundKind(kind));
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetBootDisplayKind(const WebBootDisplayKind bootDisplayKind) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::BootDisplayKind, common::BootDisplayKind(bootDisplayKind));
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetJsExtensionEnabled(const bool jsExtensionEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::GeneralJsExtensionEnabled, jsExtensionEnabled);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetDisplayUrlKind(const WebDisplayUrlKind displayUrlKind) NN_NOEXCEPT
{
    const bool useDomain = (displayUrlKind == WebDisplayUrlKind_Domain);
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UseDommainForPageInfo, useDomain);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetTouchEnabledOnContents(const bool touchEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::TouchEnabledOnContents, touchEnabled);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetUserAgentAdditionalString(const char* pString) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::UserAgentAdditionalString,
        UserAgentAdditionalStringMaxLength, pString);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetMediaPlayerAutoCloseEnabled(const bool autoCloseEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::MediaPlayerAutoCloseEnabled, autoCloseEnabled);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetPageCacheEnabled(const bool pageCacheEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::PageCacheEnabled, pageCacheEnabled);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetPageFadeEnabled(const bool pageFadeEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::PageFadeEnabled, pageFadeEnabled);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetWebAudioEnabled(const bool webAudioEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::WebAudioEnabled, webAudioEnabled);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetPageScrollIndicatorEnabled(const bool pageScrollIndicatorEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::PageScrollIndicatorEnabled, pageScrollIndicatorEnabled);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetMediaPlayerSpeedControlEnabled(const bool mediaPlayerSpeedControlEnabled) NN_NOEXCEPT
{
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::MediaPlayerSpeedControlEnabled, mediaPlayerSpeedControlEnabled);
}

//------------------------------------------------------------------------
void ShowWebPageArg::SetMediaAutoPlayEnabled(bool autoPlayEnabled) NN_NOEXCEPT
{
    // 自動再生を可能としている場合、自動再生抑制を無効化するため、フラグを反転させる
    common::CommonArgData::SetData(m_Data, common::CommonArgData::ArgKind::MediaPlayerUserGestureRestrictionEnabled, !autoPlayEnabled);
}

//------------------------------------------------------------------------
uint8_t* ShowWebPageArg::Data() NN_NOEXCEPT
{
    return m_Data;
}

//------------------------------------------------------------------------
WebPageReturnValue::WebPageReturnValue() NN_NOEXCEPT
: m_ExitReason()
, m_LastUrl()
, m_LastUrlSize()
{
}

//------------------------------------------------------------------------
WebExitReason WebPageReturnValue::GetWebExitReason() const NN_NOEXCEPT
{
    return static_cast<WebExitReason>(m_ExitReason);
}

//------------------------------------------------------------------------
const char* WebPageReturnValue::GetLastUrl() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_ExitReason == WebExitReason_CallbackUrlReached);
    return m_LastUrl;
}

//------------------------------------------------------------------------
size_t WebPageReturnValue::GetLastUrlSize() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_ExitReason == WebExitReason_CallbackUrlReached);
    return size_t(m_LastUrlSize);
}

}} // namespace nn::web
