﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/web_OfflineApiPrivate.h>

#include <nn/applet/applet_Types.h>
#include <nn/la/la_CommonArgumentsWriter.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/web/detail/web_OfflineApiDetail.h>
#include <nn/web/detail/web_OfflineTypesDetail.h>

namespace nn { namespace web {

//------------------------------------------------------------------------
nn::Result ShowApplicationLegalInformationPage(
    OfflineHtmlPageReturnValue* pOutputOfflineHtmlPageReturnValue,
    const ShowApplicationLegalInformationPageArg& arg) NN_NOEXCEPT
{
    auto handle = nn::web::common::CommonApi::PrepareLibraryApplet(applet::AppletId_LibraryAppletOfflineWeb);

    // 共通引数をプッシュ
    nn::la::CommonArgumentsWriter writer(nn::web::common::ShimVersion, detail::OfflineShimVersion);
    writer.PushToInChannel(handle);

    // アプリケーションの「リーガル情報」を開くための起動引数をプッシュ
    arg.PushToInChannel(handle);

    // アプリケーションの「リーガル情報」を開く
    return nn::web::common::CommonApi::StartLibraryAppletAndWait(pOutputOfflineHtmlPageReturnValue, sizeof(*pOutputOfflineHtmlPageReturnValue), handle);
}

//------------------------------------------------------------------------
nn::Result ShowSystemDataPage(OfflineHtmlPageReturnValue* pOutputOfflineHtmlPageReturnValue,
    const ShowSystemDataPageArg& arg) NN_NOEXCEPT
{
    auto handle = nn::web::common::CommonApi::PrepareLibraryApplet(applet::AppletId_LibraryAppletOfflineWeb);

    // 共通引数をプッシュ
    nn::la::CommonArgumentsWriter writer(nn::web::common::ShimVersion, detail::OfflineShimVersion);
    writer.PushToInChannel(handle);

    // システムデータを開くための起動引数をプッシュ
    arg.PushToInChannel(handle);

    // システムデータを開く
    return nn::web::common::CommonApi::StartLibraryAppletAndWait(pOutputOfflineHtmlPageReturnValue, sizeof(*pOutputOfflineHtmlPageReturnValue), handle);
}

//------------------------------------------------------------------------
nn::Result GetOfflineHtmlPageReturnValueFromStorage(OfflineHtmlPageReturnValue* pOutputOfflineHtmlPageReturnValue,
    const nn::applet::StorageHandle& handle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutputOfflineHtmlPageReturnValue);
    nn::web::common::CommonApi::ReadFromStorage(
        pOutputOfflineHtmlPageReturnValue, sizeof(*pOutputOfflineHtmlPageReturnValue), handle);
    return nn::ResultSuccess();
}

}} // namespace nn::web
