﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/web/detail/web_ShareApiDetail.h>

#include <nn/web/web_ShareApiPrivate.h>
#include <nn/web/common/web_CommonArgData.h>

namespace nn { namespace web { namespace detail {

//------------------------------------------------------------------------
void ShowSharePageArgDetail::SetCallbackUrl(uint8_t* pDst, const char* pCallbackUrl) NN_NOEXCEPT
{
    nn::web::common::CommonArgData::SetData(pDst, nn::web::common::CommonArgData::ArgKind::CallbackURL,
        ShowSharePageArg::CallbackableUrlMaxLength, pCallbackUrl);
}

//------------------------------------------------------------------------
SharePageReturnValue2_0::SharePageReturnValue2_0() NN_NOEXCEPT
: m_ExitReason()
, m_LastUrl()
, m_LastUrlSize()
{
}

//------------------------------------------------------------------------
void SharePageReturnValue2_0::SetShareExitReason(ShareExitReason shareExitReason) NN_NOEXCEPT
{
    m_ExitReason = static_cast<uint64_t>(shareExitReason);
}

//------------------------------------------------------------------------
void SharePageReturnValue2_0::SetLastUrl(const char* lastUrl) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(lastUrl);
    size_t size = std::strlen(lastUrl) + 1;
    NN_SDK_ASSERT(size <= LastUrlMaxLength);

    if (LastUrlMaxLength < size)
    {
        size = LastUrlMaxLength;
    }

    std::memcpy(m_LastUrl, lastUrl, size);
    m_LastUrl[LastUrlMaxLength - 1] = 0;

    m_LastUrlSize = static_cast<uint64_t>(size);
}

}}} // namespace nn::web::detail
