﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include "rid_Settings.h"

namespace nn { namespace rid {

    namespace {
        bool g_IsInitialized = false;
        ncm::ApplicationId g_MenuApplicationId = {};
    }

    void SetMenuApplicationId(ncm::ApplicationId menuApplicationId) NN_NOEXCEPT
    {
        g_IsInitialized = true;
        g_MenuApplicationId = menuApplicationId;
    }

    ncm::ApplicationId GetMenuApplicationId() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(g_IsInitialized, "rid::Initialize() is needed.\n");
        return g_MenuApplicationId;
    }
}}
