﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <nn/fs/fs_ResultHandler.h>
#include <string>
#include <nn/manu/manu_Api.h>
#include <nn/nn_SdkLog.h>
#include <nn/spl/spl_Api.h>
#include <nn/os.h>

#include "../repair_Utility.h"
#include "repair_UnsafeExtract.h"
#include "repair_UnsafeEntry.h"
#include "repair_MessageReporter.h"

namespace nn { namespace repair { namespace detail {


nn::Result UnsafeExtract::ExportSystemData() const NN_NOEXCEPT
{
    SendMessage("export system save data\n");

    UnsafeEntry entry(nn::fs::SaveDataSpaceId::ProperSystem, "System", m_OutputPath);
    // UnsafeEntry entry(nn::fs::SaveDataSpaceId::System, "System", m_OutputPath);

    NN_REPAIR_RESULT_DO(entry.WriteTree());

    NN_RESULT_SUCCESS;
}

nn::Result UnsafeExtract::ExportUserData() const NN_NOEXCEPT
{
    SendMessage("export user save data\n");

    UnsafeEntry entry(nn::fs::SaveDataSpaceId::User, "User", m_OutputPath);
    NN_REPAIR_RESULT_DO(entry.WriteTree());

    NN_RESULT_SUCCESS;
}

nn::Result UnsafeExtract::ExportThumbnailData() const NN_NOEXCEPT
{
    SendMessage("export thumbnail data\n");

    // (TODO)
    // ThumbnailDataEntry entry;
    // NN_REPAIR_RESULT_DO(entry.WriteArchive(m_pFile, pList));

    NN_RESULT_SUCCESS;
}

nn::Result UnsafeExtract::ExportAlbumData() const NN_NOEXCEPT
{
    SendMessage("export album data\n");

    // (TODO)
    // AlbumDataEntry entry;
    // NN_REPAIR_RESULT_DO(entry.WriteArchive(m_pFile));

    NN_RESULT_SUCCESS;
}


nn::Result UnsafeExtract::Export() const NN_NOEXCEPT
{
    // fs のアボートを抑制
    nn::fs::SetEnabledAutoAbort(false);

    // バックアップ記録ファイルの作成
    NN_REPAIR_RESULT_DO(CreateRecord(BackupRecordName));

    // 破損記録ファイルの作成
    NN_REPAIR_RESULT_DO(CreateRecord(CorruptionRecordName));

    NN_REPAIR_RESULT_DO(this->ExportSystemData());
    NN_REPAIR_RESULT_DO(this->ExportUserData());
//  NN_REPAIR_RESULT_DO(this->ExportThumbnailData());
//  NN_REPAIR_RESULT_DO(this->ExportAlbumData());

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::repair::detail

