﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/os.h>

namespace nn { namespace repair { namespace detail {

//!< 速度計測を扱うクラスです
class Surveyor
{
    protected:

        //!< 転送量
        uint64_t m_TotalSize;

        //!< 計測開始時間
        int64_t  m_BaseTime;

        //!< 前回 LAP時の転送量
        uint64_t m_LapSize;

        //!< 前回 LAP時の経過時間
        int64_t  m_LapTime;

        //!< 処理したファイル数
        int64_t  m_FileCount;

        //!< Lap 計測するカウント
        int      m_LapIntervalCount;

        //!< 改行カウント
        int      m_CrInc;

        //!< 総転送量
        static uint64_t s_TotalSizeSum;

        //!< 総経過時間
        static int64_t  s_ElapsedTimeSum;

        //!< 総ファイル数
        static int64_t  s_TotalFileCount;

    public:

        Surveyor() NN_NOEXCEPT;

        static uint64_t TotalSizeSum()   { return s_TotalSizeSum; };

        static int64_t  ElapsedTimeSum() { return s_ElapsedTimeSum; };

        static int64_t  TotalFileCount() { return s_TotalFileCount; };

        static void ResetSum() NN_NOEXCEPT;

        int64_t FileCount(){ return m_FileCount; };

        //!< 計測開始
        void StartTick() NN_NOEXCEPT;

        //!< file 数表示
        void ShowFileCount(int64_t count) NN_NOEXCEPT;

        //!< Interval 計測
        void Snap(uint64_t size) NN_NOEXCEPT;

        //!< Tick 表示
        void ShowTick(int tick, int max) NN_NOEXCEPT;

        //!< 計測結果の表示
        void ShowResult() const NN_NOEXCEPT;




};

}}} // namespace nn::repair::detail

