﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include "repair_MessageReporter.h"

namespace nn { namespace repair { namespace detail {

MessageReporter g_MessageReporter;

void MessageReporter::Register(
        const ReportCallbackStruct* pCallback) NN_NOEXCEPT
{
    m_reportCallback = *pCallback;
}

void MessageReporter::Unregister() NN_NOEXCEPT
{
    const ReportCallbackStruct zeroCallback = {nullptr,nullptr,nullptr,nullptr,nullptr,nullptr};
    m_reportCallback = zeroCallback;
}

void MessageReporter::Send(const char* message) NN_NOEXCEPT
{
    if (m_reportCallback.pFunctionBoth != nullptr)
    {
        m_reportCallback.pFunctionBoth(message);
    }
}

void MessageReporter::SendScreen(const char* message) NN_NOEXCEPT
{
    if (m_reportCallback.pFunctionScreen != nullptr)
    {
        m_reportCallback.pFunctionScreen(message);
    }
}

void MessageReporter::SendConsole(const char* message) NN_NOEXCEPT
{
    if (m_reportCallback.pFunctionConsole != nullptr)
    {
        m_reportCallback.pFunctionConsole(message);
    }
}

void RegisterReportCallBack(const ReportCallbackStruct* pCallback) NN_NOEXCEPT
{
    g_MessageReporter.Register(pCallback);
}

void UnregisterReportCallBack() NN_NOEXCEPT
{
    g_MessageReporter.Unregister();
}

void SendMessage(const char* pFormat, ...) NN_NOEXCEPT
{
    char str[512];
    va_list args;
    va_start(args, pFormat);
    vsnprintf(str, sizeof(str), pFormat, args);
    va_end(args);

    NN_SDK_LOG(str);
    g_MessageReporter.Send(str);
}

void SendMessageToScreen(const char* pFormat, ...) NN_NOEXCEPT
{
    char str[512];
    va_list args;
    va_start(args, pFormat);
    vsnprintf(str, sizeof(str), pFormat, args);
    va_end(args);

    NN_SDK_LOG(str);
    g_MessageReporter.SendScreen(str);
}

void SendMessageToConsole(const char* pFormat, ...) NN_NOEXCEPT
{
    char str[512];
    va_list args;
    va_start(args, pFormat);
    vsnprintf(str, sizeof(str), pFormat, args);
    va_end(args);

    NN_SDK_LOG(str);
    g_MessageReporter.SendConsole(str);
}

}}} // namespace nn::repair::detail

