﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/settings/system/settings_FirmwareVersion.h>
#include <nn/nn_Result.h>

namespace nn { namespace repair { namespace detail {

//!< ファームウェアバージョンを扱うクラスです。
class FirmwareVersion final
{
private:
    //!< バージョン情報
    nn::settings::system::FirmwareVersion m_version;

public:
    const int DisplayVersionLength = sizeof(m_version.displayVersion) + 1;

    explicit FirmwareVersion() NN_NOEXCEPT
    {
        nn::settings::system::GetFirmwareVersion(&m_version);
    }

    explicit FirmwareVersion(bool isFixed) NN_NOEXCEPT;

    //!< 表示用 FW バージョンを返します。
    const char* DisplayVersion() const
    {
        return (char*)m_version.displayVersion;
    }

    //!< 自動CUP 可能な FW Version かを返します。
    bool IsAvailableAutoCup() const NN_NOEXCEPT;

    //!< Shutdown API を呼び出し可能な FW Version かを返します。
    bool IsAvailableShutdown() const NN_NOEXCEPT;

    //!< Migration 状態取得の settings API を呼び出し可能な FW Version かを返します。
    bool IsAvailableMigration() const NN_NOEXCEPT;

};


//!< set:sys 権限回避 の為の置き換え用クラス
class FirmwareVersionNoCheck final
{
public:
    explicit FirmwareVersionNoCheck() NN_NOEXCEPT
    {
    }

    //!< 自動CUP 可能な FW Version かを返します。
    bool IsAvailableAutoCup() const NN_NOEXCEPT
    {
        return true;
    }

    //!< Shutdown API を呼び出し可能な FW Version かを返します。
    bool IsAvailableShutdown() const NN_NOEXCEPT
    {
        return true;
    }
};

}}} // namespace nn::repair::detail
