﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>
#include <nn/repair.h>
#include <nn/result/result_HandlingUtility.h>

#include "repair_FirmwareVersion.h"

namespace nn { namespace repair { namespace detail {

bool FirmwareVersion::IsAvailableAutoCup() const NN_NOEXCEPT
{
    nn::settings::system::FirmwareVersion secondNupFirmwareVersion;
    secondNupFirmwareVersion.major = 2;
    secondNupFirmwareVersion.minor = 0;
    secondNupFirmwareVersion.micro = 0;

    return ( m_version.GetComparableVersion() >= secondNupFirmwareVersion.GetComparableVersion() );
}

bool FirmwareVersion::IsAvailableShutdown() const NN_NOEXCEPT
{
    nn::settings::system::FirmwareVersion thirdNupVersion;
    thirdNupVersion.major = 3;
    thirdNupVersion.minor = 0;
    thirdNupVersion.micro = 0;

    return ( m_version.GetComparableVersion() >= thirdNupVersion.GetComparableVersion() );
}

bool FirmwareVersion::IsAvailableMigration() const NN_NOEXCEPT
{
    nn::settings::system::FirmwareVersion fourthNupVersion;
    fourthNupVersion.major = 4;
    fourthNupVersion.minor = 0;
    fourthNupVersion.micro = 0;

    return ( m_version.GetComparableVersion() >= fourthNupVersion.GetComparableVersion() );
}

}}} // namespace nn::repair::detail
