﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <string>

namespace nn { namespace repair { namespace detail {

//!< ディレクトリを扱うクラスです。
class Directory final
{
private:
    //!< ディレクトリのパス
    std::string m_Path;

public:
    explicit Directory(const std::string& path) NN_NOEXCEPT
        : m_Path(path)
    {
    }

    //!< 存在するかを確認します。
    bool IsFound() const NN_NOEXCEPT;

    //!< 作成します。
    nn::Result Create() const NN_NOEXCEPT;

    //!< 削除します。
    nn::Result Delete() const NN_NOEXCEPT;
};

}}} // namespace nn::repair::detail

