﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/g3d/res/g3d_ResTexture.h>
#include <nw/g3d/res/g3d_ResFile.h>
#include <string>

namespace nw { namespace g3d { namespace res {

void ResTexture::Setup()
{
    // テクスチャセットアップ
    GfxTexture* texture = this->GetGfxTexture();
    texture->SetImagePtrs(this->GetData(), this->GetMipData());

    texture->Setup();
    texture->DCFlush();
}

void ResTexture::Cleanup()
{
    // テクスチャセットアップ
    GfxTexture* texture = this->GetGfxTexture();
    texture->SetImagePtrs(NULL, NULL);

    texture->Cleanup();
}

BindResult ResTextureRef::Bind(const ResFile* pFile)
{
    NW_G3D_ASSERT_NOT_NULL_DETAIL(pFile, "%s\n", NW_G3D_RES_GET_NAME(this, GetName()));

    if (ref().ofsRefData == 0)
    {
        const ResTexture* pTexture = pFile->GetTexture(ref().ofsName.GetResName());
        if (pTexture != NULL)
        {
            ref().ofsRefData.set_ptr(pTexture->ptr());
            return BindResult::Bound(BIND_TEXTURE);
        }
        else
        {
            return BindResult::NotBound(BIND_TEXTURE);
        }
    }
    return BindResult();
}

void ResTextureRef::ForceBind(const ResTexture* pTarget)
{
    NW_G3D_ASSERT_NOT_NULL_DETAIL(pTarget, "%s\n", NW_G3D_RES_GET_NAME(this, GetName()));

    ref().ofsRefData.set_ptr(pTarget->ptr());
}

void ResTextureRef::Release()
{
    ref().ofsRefData = 0;
}

}}} // namespace nw::g3d::res
