#----------------------------------------------------------------------------
# Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.
#
# These coded instructions, statements, and computer programs contain
# proprietary information of Nintendo of America Inc. and/or Nintendo
# Company Ltd., and are protected by Federal copyright law.  They may
# not be disclosed to third parties or copied or duplicated in any form,
# in whole or in part, without the prior written consent of Nintendo.
#----------------------------------------------------------------------------

LOCAL_PATH := $(call my-dir)

include $(CLEAR_VARS)

LOCAL_MODULE    := g3d
ifeq ($(NW_BUILD), Debug)
LOCAL_CFLAGS    := -DNW_DEBUG
else
ifeq ($(NW_BUILD), Release)
LOCAL_CFLAGS    := -DNW_RELEASE
else
LOCAL_CFLAGS    := -DNW_DEVELOP
endif
endif

LOCAL_SRC_FILES     :=  ../edit/detail/g3d_EditAnimControl.cpp \
					../edit/detail/g3d_EditAnimCurve.cpp \
					../edit/detail/g3d_EditAnimObj.cpp \
					../edit/detail/g3d_EditBone.cpp \
					../edit/detail/g3d_EditHostFileIO.cpp \
					../edit/detail/g3d_EditManager.cpp \
					../edit/detail/g3d_EditMaterialObj.cpp \
					../edit/detail/g3d_EditModelObj.cpp \
					../edit/detail/g3d_EditPickup.cpp \
					../edit/detail/g3d_EditRenderInfo.cpp \
					../edit/detail/g3d_EditRenderInfoObj.cpp \
					../edit/detail/g3d_EditSceneAnimObj.cpp \
					../edit/detail/g3d_EditShaderArchive.cpp \
					../edit/detail/g3d_EditShaderProgram.cpp \
					../edit/detail/g3d_EditShadingModel.cpp \
					../edit/detail/g3d_EditShapeObj.cpp \
					../edit/detail/g3d_EditSkeletonObj.cpp \
					../edit/detail/g3d_EditSocket.cpp \
					../edit/detail/g3d_EditUtility.cpp \
					../edit/detail/ut/g3d_EditWorkBuffer.cpp \
					../edit/g3d_EditServer.cpp \
					../fnd/g3d_EglUtility.cpp \
					../fnd/g3d_GfxManage.cpp \
					../fnd/g3d_GfxObject.cpp \
					../fnd/g3d_GfxShader.cpp \
					../fnd/g3d_GfxState.cpp \
					../fnd/g3d_GLUtility.cpp \
					../fnd/g3d_GX2Utility.cpp \
					../fnd/g3d_WinUtility.cpp \
					../g3d.cpp \
					../g3d_AnimObj.cpp \
					../g3d_Billboard.cpp \
					../g3d_MaterialObj.cpp \
					../g3d_ModelObj.cpp \
					../g3d_SceneAnimObj.cpp \
					../g3d_ShaderObj.cpp \
					../g3d_ShaderParamAnimObj.cpp \
					../g3d_ShaderUtility.cpp \
					../g3d_ShapeAnimObj.cpp \
					../g3d_ShapeObj.cpp \
					../g3d_SkeletalAnimObj.cpp \
					../g3d_SkeletonObj.cpp \
					../g3d_TexPatternAnimObj.cpp \
					../g3d_VisibilityAnimObj.cpp \
					../math/g3d_MathCommon.cpp \
					../res/g3d_ResAnimCurve.cpp \
					../res/g3d_ResDictionary.cpp \
					../res/g3d_ResFile.cpp \
					../res/g3d_ResMaterial.cpp \
					../res/g3d_ResModel.cpp \
					../res/g3d_ResSceneAnim.cpp \
					../res/g3d_ResShader.cpp \
					../res/g3d_ResShaderParamAnim.cpp \
					../res/g3d_ResShape.cpp \
					../res/g3d_ResShapeAnim.cpp \
					../res/g3d_ResSkeletalAnim.cpp \
					../res/g3d_ResSkeleton.cpp \
					../res/g3d_ResTexPatternAnim.cpp \
					../res/g3d_ResTexture.cpp \
					../res/g3d_ResUtility.cpp \
					../res/g3d_ResVisibilityAnim.cpp \
					../ut/g3d_Perf.cpp

CAFE_INCLUDES           := $(subst \,/,$(CAFE_ROOT)/system/include)
LOCAL_C_INCLUDES        := $(CAFE_INCLUDES) ../../../../Include/
LOCAL_STATIC_LIBRARIES  := android_native_app_glue

include $(BUILD_STATIC_LIBRARY)

$(call import-module,android/native_app_glue)
