﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include <nw/g3d/g3d_SkeletonObj.h>
#include "ut/g3d_FixedSizeArray.h"
#include "ut/g3d_EditWorkBuffer.h"

namespace nw { namespace g3d {

class ModelObj;
class SkeletonObj;

namespace res {

class ResSkeleton;

} // namespace res

namespace edit {

class EditServer;
class IAllocator;

namespace detail {

class EditManager;

/**
    @briefprivate 編集対象スケルトンクラスです。
 */
class EditSkeletonObj
{
    friend class EditModelObj;
public:
    void Setup();
    void Cleanup();

private:
    explicit EditSkeletonObj(IAllocator* allocator);

    bool Init(nw::g3d::ModelObj* ownerModelObj, nw::g3d::SkeletonObj* skeletonObj);
    void Destroy();

    bool ReinitBuffer(nw::g3d::res::ResSkeleton* resSkeleton);

    void SetupSkeletonInstance(nw::g3d::res::ResSkeleton* resSkeleton);

    IAllocator*                     m_pAllocator;

    nw::g3d::ModelObj*              m_pOwnerModel;
    nw::g3d::SkeletonObj*           m_pSkeleton;
    nw::g3d::res::ResSkeleton*      m_pOriginalSkeleton;

    void*                           m_pOriginalBuffer;
    u32                             m_OriginalBufferSize;

    void*                           m_pOriginalBlockBuffer;
    u32                             m_OriginalBlockBufferSize;

    int                             m_OriginalBufferingCount;

    ut::detail::EditWorkBuffer    m_WorkBuffer;
    ut::detail::EditWorkBuffer    m_WorkBlockBuffer;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditSkeletonObj);
};

}} // nw::g3d::edit::detail
}} // namespace nw::g3d

#endif // NW_G3D_CONFIG_USE_HOSTIO
