﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "g3d_EditAnimObj.h"

namespace nw { namespace g3d {

class ModelAnimObj;

namespace res {

class ResFile;
class ResSkeletalAnim;

} // namespace res

namespace edit {

class IAllocator;

namespace detail {

class EditSkeletalAnimObj : public EditAnimObj
{
public:
    explicit EditSkeletalAnimObj(
        IAllocator* pAllocator,
        nw::g3d::res::ResFile* pResFile)
        : EditAnimObj(pAllocator, pResFile, EDIT_SKELETAL_ANIM)
        , m_pRetargetingHostModel(NULL)
    {
    }

    virtual ~EditSkeletalAnimObj()
    {
        UnbindAllModelObjs();
        DestroyDataForEditingAnimCurve();
    }

    virtual void ApplyAnimTo(ModelObj* pModelObj)
    {
        SkeletalAnimObj* pSkeletalAnimObj = GetSkeletalAnimObj(pModelObj);
        pSkeletalAnimObj->ApplyTo(pModelObj->GetSkeleton());
    }

    virtual bool CreateDataForEditingAnimCurve();
    virtual void DestroyDataForEditingAnimCurve();

    void SetRetargetingHostModel(const ModelObj* pRetargetHostModelObj)
    {
        NW_G3D_EDIT_ASSERT_NOT_NULL(pRetargetHostModelObj);
        m_pRetargetingHostModel = pRetargetHostModelObj;
        for (int i = 0, end = GetBoundModelObjCount(); i < end; ++i)
        {
            ModelObj* pBoundModelObj = GetBoundModelObj(i);
            if (m_SetupFlag && pBoundModelObj)
            {
                SkeletalAnimObj* pSkeletalAnimObj = GetSkeletalAnimObj(i);
                pSkeletalAnimObj->Bind(pBoundModelObj, m_pRetargetingHostModel);
            }
        }
    }

    void UnsetRetargetingHostModel()
    {
        m_pRetargetingHostModel = NULL;
        for (int i = 0, end = GetBoundModelObjCount(); i < end; ++i)
        {
            ModelObj* pBoundModelObj = GetBoundModelObj(i);
            if (m_SetupFlag && pBoundModelObj)
            {
                SkeletalAnimObj* pSkeletalAnimObj = GetSkeletalAnimObj(i);
                pSkeletalAnimObj->Bind(pBoundModelObj);
            }
        }
    }

    const ModelObj* GetRetargetingHostModel() const
    {
        return m_pRetargetingHostModel;
    }

protected:
    SkeletalAnimObj* GetSkeletalAnimObj(ModelObj* pModelObj)
    {
        return static_cast<SkeletalAnimObj*>(GetAssociatedAnimObj(pModelObj));
    }

    SkeletalAnimObj* GetSkeletalAnimObj(int index)
    {
        return static_cast<SkeletalAnimObj*>(GetAnimObj(index));
    }

    virtual void ResetToOriginalValue(ModelObj* pBoundModelObj);
    virtual ModelAnimObj* CreateAnimObj()
    {
        void* buffer = m_pAllocator->Alloc(sizeof(SkeletalAnimObj), DEFAULT_ALIGNMENT);
        SkeletalAnimObj* pSkeletalAnimObj = new (buffer) SkeletalAnimObj();
        return pSkeletalAnimObj;
    }

protected:
    virtual bool SetupInternal(ModelObj* pBindTargetModelObj, ModelAnimObj* pBoundAnimObj);

private:
    const ModelObj*             m_pRetargetingHostModel;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditSkeletalAnimObj);
};


}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
