﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "ut/g3d_EditWorkBuffer.h"
#include "g3d_EditBlinkingObj.h"

namespace nw { namespace g3d {

class ModelObj;
class ShapeObj;

namespace res {

class ResShape;

} // namespace res

namespace edit {

class EditServer;
class IAllocator;

namespace detail {

class EditManager;

/**
    @briefprivate 編集対象シェイプクラスです。
*/
class EditShapeObj : public BlinkingObj
{
public:
    explicit EditShapeObj(
        IAllocator* allocator,
        int index,
        nw::g3d::ModelObj* ownerModelObj,
        nw::g3d::ShapeObj* shapeObj);

    bool Init();
    void Destroy();

    void Setup();
    void Cleanup();

    void SetLodLevel(int level);
    void ResetLodLevel();

    void SetViewDependent(bool depends)
    {
        m_ViewDependent = depends;
    }

    bool ReinitBuffer(nw::g3d::res::ResShape* resShape);
    void SetupShapeInstance(nw::g3d::res::ResShape* resShape);

private:
    virtual void Show() throw();
    virtual void Hide() throw();
    virtual bool IsVisibleByDefault() const throw();

    bool ReinitBlockBuffer();

    void UpdateLodLevel(nw::g3d::res::ResShape* resShape);

    enum
    {
        ForceMeshLodDisabled = -1
    };

    IAllocator*             m_pAllocator;

    int                     m_Index;
    nw::g3d::ModelObj*      m_pOwnerModel;
    nw::g3d::ShapeObj*      m_pShape;
    nw::g3d::res::ResShape* m_pOriginalShape;

    void*                   m_pOriginalBuffer;
    int                     m_OriginalViewCount;
    bool                    m_OriginalIsViewDependent;
    bool                    m_OriginalIsBounding;
    int                     m_OriginalBufferingCount;

    void*                   m_pOriginalBlockBuffer;
    u32                     m_OriginalBlockBufferSize;

    void*                   m_pOriginalMeshArray;
    void*                   m_pMeshArray;
    void*                   m_pOriginalSubMeshBoundingArray;
    void*                   m_pSubMeshBoundingArray;

    bool                    m_ViewDependent;

    ut::detail::EditWorkBuffer    m_WorkBuffer;
    ut::detail::EditWorkBuffer    m_WorkBlockBuffer;
    ut::detail::EditWorkBuffer    m_WorkUserAreaBuffer;
    ut::detail::EditWorkBuffer    m_WorkMeshArrayBuffer;
    ut::detail::EditWorkBuffer    m_WorkSubMeshBoundingArrayBuffer;

    int m_CurrentForceMeshLodLevel;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditShapeObj);
};

}} // nw::g3d::edit::detail
}} // namespace nw::g3d

#endif // NW_G3D_CONFIG_USE_HOSTIO
