﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "g3d_EditAnimObj.h"

namespace nw { namespace g3d {

class ModelAnimObj;

namespace res {

class ResFile;

} // namespace res

namespace edit {
class IAllocator;

namespace detail {

class EditShapeAnimObj : public EditAnimObj
{
public:
    explicit EditShapeAnimObj(IAllocator* pAllocator, nw::g3d::res::ResFile* pResFile)
        : EditAnimObj(pAllocator, pResFile, EDIT_SHAPE_ANIM)
        , m_pEditVertexShapeAnimArray(NULL)
        , m_EditVertexShapeAnimCount(0)
    {
    }

    virtual ~EditShapeAnimObj()
    {
        UnbindAllModelObjs();
        DestroyDataForEditingAnimCurve();
    }

    virtual bool CreateDataForEditingAnimCurve();
    virtual void DestroyDataForEditingAnimCurve();
    void EditCurve(
        int animIndex,
        int curveIndex,
        const nw::g3d::res::ResAnimCurve* resAnimCurve,
        u32 resAnimCurveSize);

protected:
    virtual bool SetupInternal(ModelObj* pBindTargetModelObj, ModelAnimObj* pBoundAnimObj);
    virtual void ResetToOriginalValue(ModelObj* pBoundModelObj);
    virtual ModelAnimObj* CreateAnimObj()
    {
        void* buffer = m_pAllocator->Alloc(sizeof(ShapeAnimObj), DEFAULT_ALIGNMENT);
        ShapeAnimObj* pAnimObj = new (buffer) ShapeAnimObj();
        return pAnimObj;
    }

private:
    class EditVertexShapeAnim
    {
    public:
        explicit EditVertexShapeAnim(IAllocator* allocator, ResVertexShapeAnim* resVertexShapeAnim)
            : m_pAllocator(allocator)
            , m_pResVertexShapeAnim(resVertexShapeAnim)
            , m_pEditAnimCurveArray(NULL)
            , m_EditAnimCurveCount(0)
        {
            NW_G3D_ASSERT_NOT_NULL_DETAIL(allocator, "%s\n", NW_G3D_RES_GET_NAME(m_pResVertexShapeAnim, GetName()));
            NW_G3D_ASSERT_NOT_NULL_DETAIL(resVertexShapeAnim, "%s\n", NW_G3D_RES_GET_NAME(m_pResVertexShapeAnim, GetName()));
        }

        bool Init();
        void Destroy();

        EditAnimCurve* GetEditAnimCurve(int index)
        {
            return &m_pEditAnimCurveArray[index];
        }
        int GetEditAnimCurveCount() const
        {
            return m_EditAnimCurveCount;
        }

    private:
        ResVertexShapeAnim* GetResource()
        {
            return m_pResVertexShapeAnim;
        }

    private:
        IAllocator*             m_pAllocator;
        ResVertexShapeAnim*     m_pResVertexShapeAnim;
        EditAnimCurve*          m_pEditAnimCurveArray;
        int                     m_EditAnimCurveCount;

    private:
        NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditVertexShapeAnim);
    };

    EditVertexShapeAnim*        m_pEditVertexShapeAnimArray;
    int                         m_EditVertexShapeAnimCount;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditShapeAnimObj);
};

}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
