﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

#if NW_G3D_CONFIG_USE_HOSTIO

#include "g3d_EditAnimObj.h"

namespace nw { namespace g3d {

class ModelAnimObj;

namespace res {

class ResFile;

} // namespace res

namespace edit {
class IAllocator;

namespace detail {

class EditShaderParamAnimObj : public EditAnimObj
{
public:
    explicit EditShaderParamAnimObj(IAllocator* pAllocator, nw::g3d::res::ResFile* pResFile)
        : EditAnimObj(pAllocator, pResFile, EDIT_SHADER_PARAM_ANIM)
        , m_pMatAnimArray(NULL)
        , m_MatAnimCount(0)
    {
    }

    virtual ~EditShaderParamAnimObj()
    {
        UnbindAllModelObjs();
        DestroyDataForEditingAnimCurve();
    }

    virtual bool CreateDataForEditingAnimCurve();
    virtual void DestroyDataForEditingAnimCurve();
    void EditCurve(
        int matAnimIndex,
        int curveIndex,
        const nw::g3d::res::ResAnimCurve* resAnimCurve,
        u32 resAnimCurveSize);

protected:
    explicit EditShaderParamAnimObj(IAllocator* pAllocator, nw::g3d::res::ResFile* pResFile, EditAnimKind animKind)
        : EditAnimObj(pAllocator, pResFile, animKind)
        , m_pMatAnimArray(NULL)
        , m_MatAnimCount(0)
    {
    }

    virtual bool SetupInternal(ModelObj* pBindTargetModelObj, ModelAnimObj* pBoundAnimObj);
    virtual void ResetToOriginalValue(ModelObj* pBoundModelObj);
    virtual ModelAnimObj* CreateAnimObj()
    {
        void* buffer = m_pAllocator->Alloc(sizeof(ShaderParamAnimObj), DEFAULT_ALIGNMENT);
        ShaderParamAnimObj* pAnimObj = new (buffer) ShaderParamAnimObj();
        return pAnimObj;
    }

private:
    class EditShaderParamMatAnim;
    EditShaderParamMatAnim*     m_pMatAnimArray;
    int                         m_MatAnimCount;

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditShaderParamAnimObj);
};

class EditColorAnimObj : public EditShaderParamAnimObj
{
public:
    explicit EditColorAnimObj(IAllocator* pAllocator, nw::g3d::res::ResFile* pResFile)
        : EditShaderParamAnimObj(pAllocator, pResFile, EDIT_COLOR_ANIM)
    {
    }

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditColorAnimObj);
};

class EditTexSrtAnimObj : public EditShaderParamAnimObj
{
public:
    explicit EditTexSrtAnimObj(IAllocator* pAllocator, nw::g3d::res::ResFile* pResFile)
        : EditShaderParamAnimObj(pAllocator, pResFile, EDIT_TEX_SRT_ANIM)
    {
    }

private:
    NW_G3D_DISALLOW_COPY_AND_ASSIGN(EditTexSrtAnimObj);
};


}}}} // namespace nw::g3d::edit::detail

#endif // NW_G3D_CONFIG_USE_HOSTIO
